/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobCoordinatorConfig;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.container.SamzaContainerListener;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationContainerContextFactory;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.context.JobContextImpl;
import org.apache.samza.coordinator.JobCoordinator;
import org.apache.samza.coordinator.JobCoordinatorFactory;
import org.apache.samza.coordinator.JobCoordinatorListener;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.runtime.ProcessorLifecycleListener;
import org.apache.samza.task.TaskFactory;
import org.apache.samza.util.ScalaJavaUtil;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

@InterfaceStability.Evolving
public class StreamProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamProcessor.class);
    private static final String CONTAINER_THREAD_NAME_FORMAT = "Samza StreamProcessor Container Thread-%d";
    private final JobCoordinator jobCoordinator;
    private final ProcessorLifecycleListener processorListener;
    private final TaskFactory taskFactory;
    private final Optional<ApplicationContainerContextFactory<ApplicationContainerContext>> applicationDefinedContainerContextFactoryOptional;
    private final Optional<ApplicationTaskContextFactory<ApplicationTaskContext>> applicationDefinedTaskContextFactoryOptional;
    private final Map<String, MetricsReporter> customMetricsReporter;
    private final Config config;
    private final long taskShutdownMs;
    private final String processorId;
    private final ExecutorService containerExcecutorService;
    private final Object lock = new Object();
    private volatile Throwable containerException = null;
    volatile CountDownLatch containerShutdownLatch = new CountDownLatch(1);
    @VisibleForTesting
    State state = State.NEW;
    @VisibleForTesting
    SamzaContainer container = null;
    @VisibleForTesting
    JobCoordinatorListener jobCoordinatorListener = null;

    public State getState() {
        return this.state;
    }

    @Deprecated
    public StreamProcessor(Config config, Map<String, MetricsReporter> customMetricsReporters, TaskFactory taskFactory, ProcessorLifecycleListener processorListener) {
        this(config, customMetricsReporters, taskFactory, processorListener, null);
    }

    @Deprecated
    public StreamProcessor(Config config, Map<String, MetricsReporter> customMetricsReporters, TaskFactory taskFactory, ProcessorLifecycleListener processorListener, JobCoordinator jobCoordinator) {
        this(config, customMetricsReporters, taskFactory, Optional.empty(), Optional.empty(), sp2 -> processorListener, jobCoordinator);
    }

    public StreamProcessor(Config config, Map<String, MetricsReporter> customMetricsReporters, TaskFactory taskFactory, Optional<ApplicationContainerContextFactory<ApplicationContainerContext>> applicationDefinedContainerContextFactoryOptional, Optional<ApplicationTaskContextFactory<ApplicationTaskContext>> applicationDefinedTaskContextFactoryOptional, StreamProcessorLifecycleListenerFactory listenerFactory, JobCoordinator jobCoordinator) {
        Preconditions.checkNotNull((Object)listenerFactory, (Object)"StreamProcessorListenerFactory cannot be null.");
        this.config = config;
        this.customMetricsReporter = customMetricsReporters;
        this.taskFactory = taskFactory;
        this.applicationDefinedContainerContextFactoryOptional = applicationDefinedContainerContextFactoryOptional;
        this.applicationDefinedTaskContextFactoryOptional = applicationDefinedTaskContextFactoryOptional;
        this.taskShutdownMs = new TaskConfigJava(config).getShutdownMs();
        this.jobCoordinator = jobCoordinator != null ? jobCoordinator : this.createJobCoordinator();
        this.jobCoordinatorListener = this.createJobCoordinatorListener();
        this.jobCoordinator.setListener(this.jobCoordinatorListener);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CONTAINER_THREAD_NAME_FORMAT).setDaemon(true).build();
        this.containerExcecutorService = Executors.newSingleThreadExecutor(threadFactory);
        this.processorId = this.jobCoordinator.getProcessorId();
        this.processorListener = listenerFactory.createInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.NEW) {
                this.processorListener.beforeStart();
                this.state = State.STARTED;
                this.jobCoordinator.start();
            } else {
                LOGGER.info("Start is no-op, since the current state is {} and not {}.", (Object)this.state, (Object)State.NEW);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.STOPPING && this.state != State.STOPPED) {
                this.state = State.STOPPING;
                try {
                    LOGGER.info("Shutting down the container: {} of stream processor: {}.", (Object)this.container, (Object)this.processorId);
                    boolean hasContainerShutdown = this.stopSamzaContainer();
                    if (!hasContainerShutdown) {
                        LOGGER.info("Interrupting the container: {} thread to die.", (Object)this.container);
                        this.containerExcecutorService.shutdownNow();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.error(String.format("Exception occurred on container: %s shutdown of stream processor: %s.", this.container, this.processorId), throwable);
                }
                LOGGER.info("Shutting down JobCoordinator of stream processor: {}.", (Object)this.processorId);
                this.jobCoordinator.stop();
            } else {
                LOGGER.info("StreamProcessor state is: {}. Ignoring the stop.", (Object)this.state);
            }
        }
    }

    @VisibleForTesting
    JobCoordinator getCurrentJobCoordinator() {
        return this.jobCoordinator;
    }

    @VisibleForTesting
    SamzaContainer getContainer() {
        return this.container;
    }

    @VisibleForTesting
    SamzaContainer createSamzaContainer(String processorId, JobModel jobModel) {
        return SamzaContainer.apply(processorId, jobModel, ScalaJavaUtil.toScalaMap(this.customMetricsReporter), this.taskFactory, JobContextImpl.fromConfigWithDefaults(this.config), (Option<ApplicationContainerContextFactory<ApplicationContainerContext>>)Option.apply(this.applicationDefinedContainerContextFactoryOptional.orElse(null)), (Option<ApplicationTaskContextFactory<ApplicationTaskContext>>)Option.apply(this.applicationDefinedTaskContextFactoryOptional.orElse(null)));
    }

    private JobCoordinator createJobCoordinator() {
        String jobCoordinatorFactoryClassName = new JobCoordinatorConfig(this.config).getJobCoordinatorFactoryClassName();
        return Util.getObj(jobCoordinatorFactoryClassName, JobCoordinatorFactory.class).getJobCoordinator(this.config);
    }

    private boolean stopSamzaContainer() {
        boolean hasContainerShutdown = true;
        if (this.container != null) {
            block4: {
                try {
                    this.container.shutdown();
                    LOGGER.info("Waiting {} ms for the container: {} to shutdown.", (Object)this.taskShutdownMs, (Object)this.container);
                    hasContainerShutdown = this.containerShutdownLatch.await(this.taskShutdownMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Exception occurred when shutting down the container: {}.", (Object)this.container, (Object)e);
                    hasContainerShutdown = false;
                    if (this.containerException == null) break block4;
                    this.containerException = e;
                }
            }
            LOGGER.info(String.format("Shutdown status of container: %s for stream processor: %s is: %b.", this.container, this.processorId, hasContainerShutdown));
        }
        if (!hasContainerShutdown && this.containerException == null) {
            this.containerException = new TimeoutException("Container shutdown timed out after " + this.taskShutdownMs + " ms.");
        }
        return hasContainerShutdown;
    }

    private JobCoordinatorListener createJobCoordinatorListener() {
        return new JobCoordinatorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onJobModelExpired() {
                Object object = StreamProcessor.this.lock;
                synchronized (object) {
                    if (StreamProcessor.this.state == State.STARTED || StreamProcessor.this.state == State.RUNNING) {
                        StreamProcessor.this.state = State.IN_REBALANCE;
                        LOGGER.info("Job model expired. Shutting down the container: {} of stream processor: {}.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
                        boolean hasContainerShutdown = StreamProcessor.this.stopSamzaContainer();
                        if (!hasContainerShutdown) {
                            LOGGER.warn("Container: {} shutdown was unsuccessful. Stopping the stream processor: {}.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
                            StreamProcessor.this.state = State.STOPPING;
                            StreamProcessor.this.jobCoordinator.stop();
                        } else {
                            LOGGER.info("Container: {} shutdown completed for stream processor: {}.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
                        }
                    } else {
                        LOGGER.info("Ignoring onJobModelExpired invocation since the current state is {} and not in {}.", (Object)StreamProcessor.this.state, (Object)ImmutableList.of((Object)((Object)State.RUNNING), (Object)((Object)State.STARTED)));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewJobModel(String processorId, JobModel jobModel) {
                Object object = StreamProcessor.this.lock;
                synchronized (object) {
                    if (StreamProcessor.this.state == State.IN_REBALANCE) {
                        StreamProcessor.this.containerShutdownLatch = new CountDownLatch(1);
                        StreamProcessor.this.container = StreamProcessor.this.createSamzaContainer(processorId, jobModel);
                        StreamProcessor.this.container.setContainerListener(new ContainerListener());
                        LOGGER.info("Starting the container: {} for the stream processor: {}.", (Object)StreamProcessor.this.container, (Object)processorId);
                        StreamProcessor.this.containerExcecutorService.submit(StreamProcessor.this.container);
                    } else {
                        LOGGER.info("Ignoring onNewJobModel invocation since the current state is {} and not {}.", (Object)StreamProcessor.this.state, (Object)State.IN_REBALANCE);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoordinatorStop() {
                Object object = StreamProcessor.this.lock;
                synchronized (object) {
                    LOGGER.info("Shutting down the executor service of the stream processor: {}.", (Object)StreamProcessor.this.processorId);
                    boolean hasContainerShutdown = StreamProcessor.this.stopSamzaContainer();
                    if (!hasContainerShutdown) {
                        StreamProcessor.this.containerExcecutorService.shutdownNow();
                    }
                    StreamProcessor.this.state = State.STOPPED;
                }
                if (StreamProcessor.this.containerException != null) {
                    StreamProcessor.this.processorListener.afterFailure(StreamProcessor.this.containerException);
                } else {
                    StreamProcessor.this.processorListener.afterStop();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoordinatorFailure(Throwable throwable) {
                Object object = StreamProcessor.this.lock;
                synchronized (object) {
                    LOGGER.info(String.format("Coordinator: %s failed with an exception. Stopping the stream processor: %s. Original exception:", StreamProcessor.this.jobCoordinator, StreamProcessor.this.processorId), throwable);
                    boolean hasContainerShutdown = StreamProcessor.this.stopSamzaContainer();
                    if (!hasContainerShutdown) {
                        StreamProcessor.this.containerExcecutorService.shutdownNow();
                    }
                    StreamProcessor.this.state = State.STOPPED;
                }
                StreamProcessor.this.processorListener.afterFailure(throwable);
            }
        };
    }

    class ContainerListener
    implements SamzaContainerListener {
        private boolean processorOnStartCalled = false;

        ContainerListener() {
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public void afterStart() {
            LOGGER.warn("Received container start notification for container: {} in stream processor: {}.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
            if (!this.processorOnStartCalled) {
                StreamProcessor.this.processorListener.afterStart();
                this.processorOnStartCalled = true;
            }
            StreamProcessor.this.state = State.RUNNING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterStop() {
            StreamProcessor.this.containerShutdownLatch.countDown();
            Object object = StreamProcessor.this.lock;
            synchronized (object) {
                if (StreamProcessor.this.state == State.IN_REBALANCE) {
                    LOGGER.info("Container: {} of the stream processor: {} was stopped by the JobCoordinator.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
                } else {
                    LOGGER.info("Container: {} stopped. Stopping the stream processor: {}.", (Object)StreamProcessor.this.container, (Object)StreamProcessor.this.processorId);
                    StreamProcessor.this.state = State.STOPPING;
                    StreamProcessor.this.jobCoordinator.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterFailure(Throwable t) {
            StreamProcessor.this.containerException = t;
            StreamProcessor.this.containerShutdownLatch.countDown();
            Object object = StreamProcessor.this.lock;
            synchronized (object) {
                LOGGER.error(String.format("Container: %s failed with an exception. Stopping the stream processor: %s. Original exception:", StreamProcessor.this.container, StreamProcessor.this.processorId), t);
                StreamProcessor.this.state = State.STOPPING;
                StreamProcessor.this.jobCoordinator.stop();
            }
        }
    }

    @FunctionalInterface
    public static interface StreamProcessorLifecycleListenerFactory {
        public ProcessorLifecycleListener createInstance(StreamProcessor var1);
    }

    public static enum State {
        STARTED("STARTED"),
        RUNNING("RUNNING"),
        STOPPING("STOPPING"),
        STOPPED("STOPPED"),
        NEW("NEW"),
        IN_REBALANCE("IN_REBALANCE");

        private String strVal;

        private State(String strVal) {
            this.strVal = strVal;
        }

        public String toString() {
            return this.strVal;
        }
    }
}

