/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueSnapshot;
import org.apache.samza.storage.kv.KeyValueStore;

public class InternalInMemoryStore<K, V>
implements KeyValueStore<K, V> {
    private final Map<K, V> map = new LinkedHashMap();

    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("Null key provided");
        }
        return this.map.get(key);
    }

    public Map<K, V> getAll(List<K> keys) {
        HashMap<K, V> values = new HashMap<K, V>();
        for (K key : keys) {
            values.put(key, this.map.get(key));
        }
        return values;
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Null key provided");
        }
        this.map.put(key, value);
    }

    public void putAll(List<Entry<K, V>> entries) {
        for (Entry<K, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K key) {
        if (key == null) {
            throw new NullPointerException("Null key provided");
        }
        this.map.remove(key);
    }

    public void deleteAll(List<K> keys) {
        for (K key : keys) {
            this.delete(key);
        }
    }

    public KeyValueIterator<K, V> range(K from, K to) {
        throw new RuntimeException("not implemented.");
    }

    public KeyValueSnapshot<K, V> snapshot(K from, K to) {
        throw new UnsupportedOperationException("snapshot() is not supported in " + InternalInMemoryStore.class.getName());
    }

    public KeyValueIterator<K, V> all() {
        final Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
        return new KeyValueIterator<K, V>(){

            public void close() {
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Entry<K, V> next() {
                Map.Entry kv = (Map.Entry)iterator.next();
                return new Entry(kv.getKey(), kv.getValue());
            }

            public void remove() {
                iterator.remove();
            }
        };
    }

    public void close() {
    }

    public void flush() {
    }
}

