/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import org.apache.samza.SamzaException;
import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.triggers.AnyTrigger;
import org.apache.samza.operators.triggers.AnyTriggerImpl;
import org.apache.samza.operators.triggers.CountTrigger;
import org.apache.samza.operators.triggers.CountTriggerImpl;
import org.apache.samza.operators.triggers.RepeatingTrigger;
import org.apache.samza.operators.triggers.RepeatingTriggerImpl;
import org.apache.samza.operators.triggers.TimeSinceFirstMessageTrigger;
import org.apache.samza.operators.triggers.TimeSinceFirstMessageTriggerImpl;
import org.apache.samza.operators.triggers.TimeSinceLastMessageTrigger;
import org.apache.samza.operators.triggers.TimeSinceLastMessageTriggerImpl;
import org.apache.samza.operators.triggers.TimeTrigger;
import org.apache.samza.operators.triggers.TimeTriggerImpl;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.util.Clock;

public class TriggerImpls {
    public static <M, WK> TriggerImpl<M, WK> createTriggerImpl(Trigger<M> trigger, Clock clock, TriggerKey<WK> triggerKey) {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger must not be null");
        }
        if (trigger instanceof CountTrigger) {
            return new CountTriggerImpl((CountTrigger)trigger, triggerKey);
        }
        if (trigger instanceof RepeatingTrigger) {
            return new RepeatingTriggerImpl((RepeatingTrigger)trigger, clock, triggerKey);
        }
        if (trigger instanceof AnyTrigger) {
            return new AnyTriggerImpl((AnyTrigger)trigger, clock, triggerKey);
        }
        if (trigger instanceof TimeSinceLastMessageTrigger) {
            return new TimeSinceLastMessageTriggerImpl((TimeSinceLastMessageTrigger)trigger, clock, triggerKey);
        }
        if (trigger instanceof TimeTrigger) {
            return new TimeTriggerImpl((TimeTrigger)trigger, clock, triggerKey);
        }
        if (trigger instanceof TimeSinceFirstMessageTrigger) {
            return new TimeSinceFirstMessageTriggerImpl((TimeSinceFirstMessageTrigger)trigger, clock, triggerKey);
        }
        throw new SamzaException("No implementation class defined for the trigger  " + trigger.getClass().getCanonicalName());
    }
}

