/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.triggers.Cancellable;
import org.apache.samza.operators.triggers.TimeTrigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTriggerImpl<M, WK>
implements TriggerImpl<M, WK> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTriggerImpl.class);
    private final TimeTrigger<M> trigger;
    private final TriggerKey<WK> triggerKey;
    private Cancellable cancellable;
    private final Clock clock;
    private boolean shouldFire = false;

    public TimeTriggerImpl(TimeTrigger<M> trigger, Clock clock, TriggerKey<WK> key) {
        this.trigger = trigger;
        this.clock = clock;
        this.triggerKey = key;
    }

    @Override
    public void onMessage(M message, TriggerScheduler<WK> context) {
        long now = this.clock.currentTimeMillis();
        long triggerDurationMs = this.trigger.getDuration().toMillis();
        Long callbackTime = now - now % triggerDurationMs + triggerDurationMs;
        if (this.cancellable == null) {
            this.cancellable = context.scheduleCallback(() -> {
                LOG.trace("Time trigger fired");
                this.shouldFire = true;
            }, callbackTime, this.triggerKey);
        }
    }

    @Override
    public void cancel() {
        if (this.cancellable != null) {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean shouldFire() {
        return this.shouldFire;
    }
}

