/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.triggers.Cancellable;
import org.apache.samza.operators.triggers.TimeSinceLastMessageTrigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSinceLastMessageTriggerImpl<M, WK>
implements TriggerImpl<M, WK> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeSinceLastMessageTriggerImpl.class);
    private final TimeSinceLastMessageTrigger<M> trigger;
    private final long durationMs;
    private final Clock clock;
    private final TriggerKey<WK> triggerKey;
    private long callbackTime = Integer.MIN_VALUE;
    private Cancellable cancellable = null;
    private boolean shouldFire = false;

    public TimeSinceLastMessageTriggerImpl(TimeSinceLastMessageTrigger<M> trigger, Clock clock, TriggerKey<WK> key) {
        this.trigger = trigger;
        this.durationMs = trigger.getDuration().toMillis();
        this.clock = clock;
        this.triggerKey = key;
    }

    @Override
    public void onMessage(M message, TriggerScheduler<WK> context) {
        if (!this.shouldFire) {
            long currTime = this.clock.currentTimeMillis();
            if (currTime < this.callbackTime && this.cancellable != null) {
                this.cancellable.cancel();
            }
            this.callbackTime = currTime + this.durationMs;
            Runnable runnable = () -> {
                LOG.trace("Time since last message trigger fired");
                this.shouldFire = true;
            };
            this.cancellable = context.scheduleCallback(runnable, this.callbackTime, this.triggerKey);
        }
    }

    @Override
    public void cancel() {
        if (this.cancellable != null) {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean shouldFire() {
        return this.shouldFire;
    }
}

