/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.triggers.RepeatingTrigger;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.operators.triggers.TriggerImpls;
import org.apache.samza.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatingTriggerImpl<M, WK>
implements TriggerImpl<M, WK> {
    private static final Logger LOG = LoggerFactory.getLogger(RepeatingTriggerImpl.class);
    private final Trigger<M> repeatingTrigger;
    private final Clock clock;
    private final TriggerKey<WK> triggerKey;
    private TriggerImpl<M, WK> currentTriggerImpl;

    public RepeatingTriggerImpl(RepeatingTrigger<M> repeatingTrigger, Clock clock, TriggerKey<WK> key) {
        this.repeatingTrigger = repeatingTrigger.getTrigger();
        this.clock = clock;
        this.triggerKey = key;
        this.currentTriggerImpl = TriggerImpls.createTriggerImpl(this.repeatingTrigger, clock, this.triggerKey);
    }

    @Override
    public void onMessage(M message, TriggerScheduler<WK> context) {
        this.currentTriggerImpl.onMessage(message, context);
    }

    @Override
    public void cancel() {
        this.currentTriggerImpl.cancel();
    }

    public void clear() {
        LOG.trace("Clearing state for repeating trigger");
        this.currentTriggerImpl.cancel();
        this.currentTriggerImpl = TriggerImpls.createTriggerImpl(this.repeatingTrigger, this.clock, this.triggerKey);
    }

    @Override
    public boolean shouldFire() {
        return this.currentTriggerImpl.shouldFire();
    }
}

