/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.triggers.CountTrigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountTriggerImpl<M, WK>
implements TriggerImpl<M, WK> {
    private static final Logger LOG = LoggerFactory.getLogger(CountTriggerImpl.class);
    private final long triggerCount;
    private final TriggerKey<WK> triggerKey;
    private long currentCount;
    private boolean shouldFire = false;

    public CountTriggerImpl(CountTrigger<M> triggerCount, TriggerKey<WK> triggerKey) {
        this.triggerCount = triggerCount.getCount();
        this.currentCount = 0L;
        this.triggerKey = triggerKey;
    }

    @Override
    public void onMessage(M message, TriggerScheduler<WK> context) {
        ++this.currentCount;
        if (this.currentCount == this.triggerCount) {
            LOG.trace("count trigger fired for {}", message);
            this.shouldFire = true;
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean shouldFire() {
        return this.shouldFire;
    }
}

