/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.triggers.AnyTrigger;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.operators.triggers.TriggerImpls;
import org.apache.samza.util.Clock;

public class AnyTriggerImpl<M, WK>
implements TriggerImpl<M, WK> {
    private final List<Trigger<M>> triggers;
    private final List<TriggerImpl<M, WK>> triggerImpls = new ArrayList<TriggerImpl<M, WK>>();
    private final Clock clock;
    private boolean shouldFire = false;

    public AnyTriggerImpl(AnyTrigger<M> anyTrigger, Clock clock, TriggerKey<WK> triggerKey) {
        this.triggers = anyTrigger.getTriggers();
        this.clock = clock;
        for (Trigger<M> trigger : this.triggers) {
            this.triggerImpls.add(TriggerImpls.createTriggerImpl(trigger, clock, triggerKey));
        }
    }

    @Override
    public void onMessage(M message, TriggerScheduler<WK> context) {
        for (TriggerImpl<M, WK> impl : this.triggerImpls) {
            impl.onMessage(message, context);
            if (!impl.shouldFire()) continue;
            this.shouldFire = true;
            break;
        }
        if (this.shouldFire) {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        Iterator<TriggerImpl<M, WK>> it = this.triggerImpls.iterator();
        while (it.hasNext()) {
            TriggerImpl<M, WK> impl = it.next();
            impl.cancel();
            it.remove();
        }
    }

    @Override
    public boolean shouldFire() {
        for (TriggerImpl<M, WK> impl : this.triggerImpls) {
            if (!impl.shouldFire()) continue;
            this.shouldFire = true;
            break;
        }
        return this.shouldFire;
    }
}

