/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.stream;

import org.apache.samza.application.descriptors.StreamApplicationDescriptorImpl;
import org.apache.samza.operators.MessageStreamImpl;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateMessageStreamImpl<M>
extends MessageStreamImpl<M>
implements OutputStream<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateMessageStreamImpl.class);
    private final OutputStreamImpl<M> outputStream;
    private final boolean isKeyed;

    public IntermediateMessageStreamImpl(StreamApplicationDescriptorImpl appDesc, InputOperatorSpec inputOperatorSpec, OutputStreamImpl<M> outputStream) {
        super(appDesc, inputOperatorSpec);
        this.outputStream = outputStream;
        if (inputOperatorSpec.isKeyed() != outputStream.isKeyed()) {
            LOGGER.error("Input and output streams for intermediate stream {} aren't keyed consistently. Input: {}, Output: {}", new Object[]{inputOperatorSpec.getStreamId(), inputOperatorSpec.isKeyed(), outputStream.isKeyed()});
        }
        this.isKeyed = inputOperatorSpec.isKeyed() && outputStream.isKeyed();
    }

    public String getStreamId() {
        return this.outputStream.getStreamId();
    }

    public OutputStreamImpl<M> getOutputStream() {
        return this.outputStream;
    }

    public boolean isKeyed() {
        return this.isKeyed;
    }
}

