/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.impl.store.TimeSeriesKeySerde;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StatefulOperatorSpec;
import org.apache.samza.operators.spec.StoreDescriptor;
import org.apache.samza.operators.triggers.AnyTrigger;
import org.apache.samza.operators.triggers.RepeatingTrigger;
import org.apache.samza.operators.triggers.TimeBasedTrigger;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.internal.WindowInternal;
import org.apache.samza.serializers.Serde;
import org.apache.samza.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowOperatorSpec<M, WK, WV>
extends OperatorSpec<M, WindowPane<WK, WV>>
implements StatefulOperatorSpec {
    private static final Logger LOG = LoggerFactory.getLogger(WindowOperatorSpec.class);
    private final WindowInternal<M, WK, WV> window;

    WindowOperatorSpec(WindowInternal<M, WK, WV> window2, String opId) {
        super(OperatorSpec.OpCode.WINDOW, opId);
        Preconditions.checkArgument((window2.getInitializer() == null || !(window2.getInitializer() instanceof ScheduledFunction) && !(window2.getInitializer() instanceof WatermarkFunction) ? 1 : 0) != 0, (Object)"A window does not accepts a user-defined ScheduledFunction or WatermarkFunction as the initializer.");
        Preconditions.checkArgument((window2.getKeyExtractor() == null || !(window2.getKeyExtractor() instanceof ScheduledFunction) && !(window2.getKeyExtractor() instanceof WatermarkFunction) ? 1 : 0) != 0, (Object)"A window does not accepts a user-defined ScheduledFunction or WatermarkFunction as the keyExtractor.");
        Preconditions.checkArgument((window2.getEventTimeExtractor() == null || !(window2.getEventTimeExtractor() instanceof ScheduledFunction) && !(window2.getEventTimeExtractor() instanceof WatermarkFunction) ? 1 : 0) != 0, (Object)"A window does not accepts a user-defined ScheduledFunction or WatermarkFunction as the eventTimeExtractor.");
        this.window = window2;
    }

    public WindowInternal<M, WK, WV> getWindow() {
        return this.window;
    }

    public long getDefaultTriggerMs() {
        ArrayList<TimeBasedTrigger> timeBasedTriggers = new ArrayList<TimeBasedTrigger>();
        if (this.window.getDefaultTrigger() != null) {
            timeBasedTriggers.addAll(this.getTimeBasedTriggers(this.window.getDefaultTrigger()));
        }
        if (this.window.getEarlyTrigger() != null) {
            timeBasedTriggers.addAll(this.getTimeBasedTriggers(this.window.getEarlyTrigger()));
        }
        if (this.window.getLateTrigger() != null) {
            timeBasedTriggers.addAll(this.getTimeBasedTriggers(this.window.getLateTrigger()));
        }
        LOG.info("Got {} time-based triggers", (Object)timeBasedTriggers.size());
        List<Long> candidateDurations = timeBasedTriggers.stream().map(timeBasedTrigger -> timeBasedTrigger.getDuration().toMillis()).collect(Collectors.toList());
        return MathUtil.gcd(candidateDurations);
    }

    private List<TimeBasedTrigger> getTimeBasedTriggers(Trigger rootTrigger) {
        ArrayList<TimeBasedTrigger> timeBasedTriggers = new ArrayList<TimeBasedTrigger>();
        if (rootTrigger instanceof TimeBasedTrigger) {
            timeBasedTriggers.add((TimeBasedTrigger)rootTrigger);
        } else if (rootTrigger instanceof RepeatingTrigger) {
            timeBasedTriggers.addAll(this.getTimeBasedTriggers(((RepeatingTrigger)rootTrigger).getTrigger()));
        } else if (rootTrigger instanceof AnyTrigger) {
            List subTriggers = ((AnyTrigger)rootTrigger).getTriggers();
            for (Trigger subTrigger : subTriggers) {
                timeBasedTriggers.addAll(this.getTimeBasedTriggers(subTrigger));
            }
        }
        return timeBasedTriggers;
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        FoldLeftFunction fn = this.window.getFoldLeftFunction();
        return fn instanceof WatermarkFunction ? (WatermarkFunction)fn : null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        FoldLeftFunction fn = this.window.getFoldLeftFunction();
        return fn instanceof ScheduledFunction ? (ScheduledFunction)fn : null;
    }

    @Override
    public Collection<StoreDescriptor> getStoreDescriptors() {
        String storeName = this.getOpId();
        String storeFactory = "org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory";
        TimeSeriesKeySerde storeKeySerde = new TimeSeriesKeySerde(this.window.getKeySerde());
        Serde storeValSerde = this.window.getFoldLeftFunction() == null ? this.window.getMsgSerde() : this.window.getWindowValSerde();
        StoreDescriptor descriptor = new StoreDescriptor(storeName, storeFactory, storeKeySerde, storeValSerde, storeName, Collections.emptyMap());
        return Collections.singletonList(descriptor);
    }
}

