/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.StreamTableJoinFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.table.TableSpec;

@InterfaceStability.Unstable
public class StreamTableJoinOperatorSpec<K, M, R, JM>
extends OperatorSpec<M, JM> {
    private final TableSpec tableSpec;
    private final StreamTableJoinFunction<K, M, R, JM> joinFn;

    StreamTableJoinOperatorSpec(TableSpec tableSpec, StreamTableJoinFunction<K, M, R, JM> joinFn, String opId) {
        super(OperatorSpec.OpCode.JOIN, opId);
        this.tableSpec = tableSpec;
        this.joinFn = joinFn;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public StreamTableJoinFunction<K, M, R, JM> getJoinFn() {
        return this.joinFn;
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        return this.joinFn instanceof WatermarkFunction ? (WatermarkFunction)this.joinFn : null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        return this.joinFn instanceof ScheduledFunction ? (ScheduledFunction)this.joinFn : null;
    }
}

