/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaStorageConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.serializers.Serde;

public class StoreDescriptor {
    private final String storeName;
    private final String storeFactory;
    private final Serde keySerde;
    private final Serde msgSerde;
    private final String changelogStream;
    private final Map<String, String> otherProperties;

    StoreDescriptor(String storeName, String storeFactory, Serde keySerde, Serde msgSerde, String changelogStream, Map<String, String> otherProperties) {
        this.storeName = storeName;
        this.storeFactory = storeFactory;
        this.keySerde = keySerde;
        this.msgSerde = msgSerde;
        this.changelogStream = changelogStream;
        this.otherProperties = otherProperties;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public Serde getKeySerde() {
        return this.keySerde;
    }

    public Serde getMsgSerde() {
        return this.msgSerde;
    }

    public JavaStorageConfig getStorageConfigs() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(String.format(StorageConfig.FACTORY(), this.getStoreName()), this.getStoreFactory());
        configs.put(String.format(StorageConfig.CHANGELOG_STREAM(), this.getStoreName()), this.getChangelogStream());
        configs.putAll(this.getOtherProperties());
        return new JavaStorageConfig((Config)new MapConfig(configs));
    }

    private String getStoreFactory() {
        return this.storeFactory;
    }

    private String getChangelogStream() {
        return this.changelogStream;
    }

    private Map<String, String> getOtherProperties() {
        return this.otherProperties;
    }
}

