/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import com.google.common.base.Preconditions;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;

public class PartitionByOperatorSpec<M, K, V>
extends OperatorSpec<M, Void> {
    private final OutputStreamImpl<KV<K, V>> outputStream;
    private final MapFunction<? super M, ? extends K> keyFunction;
    private final MapFunction<? super M, ? extends V> valueFunction;

    PartitionByOperatorSpec(OutputStreamImpl<KV<K, V>> outputStream, MapFunction<? super M, ? extends K> keyFunction, MapFunction<? super M, ? extends V> valueFunction, String opId) {
        super(OperatorSpec.OpCode.PARTITION_BY, opId);
        Preconditions.checkArgument((!(keyFunction instanceof ScheduledFunction) && !(keyFunction instanceof WatermarkFunction) ? 1 : 0) != 0, (Object)"keyFunction for partitionBy should not implement ScheduledFunction or WatermarkFunction.");
        Preconditions.checkArgument((!(valueFunction instanceof ScheduledFunction) && !(valueFunction instanceof WatermarkFunction) ? 1 : 0) != 0, (Object)"valueFunction for partitionBy should not implement ScheduledFunction or WatermarkFunction.");
        this.outputStream = outputStream;
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
    }

    public OutputStreamImpl<KV<K, V>> getOutputStream() {
        return this.outputStream;
    }

    public MapFunction<? super M, ? extends K> getKeyFunction() {
        return this.keyFunction;
    }

    public MapFunction<? super M, ? extends V> getValueFunction() {
        return this.valueFunction;
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        return null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        return null;
    }
}

