/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import org.apache.samza.operators.KV;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SinkFunction;
import org.apache.samza.operators.functions.StreamTableJoinFunction;
import org.apache.samza.operators.spec.BroadcastOperatorSpec;
import org.apache.samza.operators.spec.FilterOperatorSpec;
import org.apache.samza.operators.spec.FlatMapOperatorSpec;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.MapOperatorSpec;
import org.apache.samza.operators.spec.MergeOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputOperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.operators.spec.PartitionByOperatorSpec;
import org.apache.samza.operators.spec.SendToTableOperatorSpec;
import org.apache.samza.operators.spec.SinkOperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.operators.spec.WindowOperatorSpec;
import org.apache.samza.operators.windows.internal.WindowInternal;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputTransformer;
import org.apache.samza.table.TableSpec;

public class OperatorSpecs {
    private OperatorSpecs() {
    }

    public static InputOperatorSpec createInputOperatorSpec(String streamId, Serde keySerde, Serde valueSerde, InputTransformer transformer, boolean isKeyed, String opId) {
        return new InputOperatorSpec(streamId, keySerde, valueSerde, transformer, isKeyed, opId);
    }

    public static <M, OM> StreamOperatorSpec<M, OM> createMapOperatorSpec(MapFunction<? super M, ? extends OM> mapFn, String opId) {
        return new MapOperatorSpec<M, OM>(mapFn, opId);
    }

    public static <M> StreamOperatorSpec<M, M> createFilterOperatorSpec(FilterFunction<? super M> filterFn, String opId) {
        return new FilterOperatorSpec<M>(filterFn, opId);
    }

    public static <M, OM> StreamOperatorSpec<M, OM> createFlatMapOperatorSpec(FlatMapFunction<? super M, ? extends OM> flatMapFn, String opId) {
        return new FlatMapOperatorSpec<M, OM>(flatMapFn, opId);
    }

    public static <M> SinkOperatorSpec<M> createSinkOperatorSpec(SinkFunction<? super M> sinkFn, String opId) {
        return new SinkOperatorSpec<M>(sinkFn, opId);
    }

    public static <M> OutputOperatorSpec<M> createSendToOperatorSpec(OutputStreamImpl<M> outputStream, String opId) {
        return new OutputOperatorSpec<M>(outputStream, opId);
    }

    public static <M, K, V> PartitionByOperatorSpec<M, K, V> createPartitionByOperatorSpec(OutputStreamImpl<KV<K, V>> outputStream, MapFunction<? super M, ? extends K> keyFunction, MapFunction<? super M, ? extends V> valueFunction, String opId) {
        return new PartitionByOperatorSpec<M, K, V>(outputStream, keyFunction, valueFunction, opId);
    }

    public static <M, WK, WV> WindowOperatorSpec<M, WK, WV> createWindowOperatorSpec(WindowInternal<M, WK, WV> window2, String opId) {
        return new WindowOperatorSpec<M, WK, WV>(window2, opId);
    }

    public static <K, M, OM, JM> JoinOperatorSpec<K, M, OM, JM> createJoinOperatorSpec(OperatorSpec<?, M> leftInputOpSpec, OperatorSpec<?, OM> rightInputOpSpec, JoinFunction<K, M, OM, JM> joinFn, Serde<K> keySerde, Serde<M> messageSerde, Serde<OM> otherMessageSerde, long ttlMs, String opId) {
        return new JoinOperatorSpec<K, M, OM, JM>(leftInputOpSpec, rightInputOpSpec, joinFn, keySerde, messageSerde, otherMessageSerde, ttlMs, opId);
    }

    public static <M> StreamOperatorSpec<M, M> createMergeOperatorSpec(String opId) {
        return new MergeOperatorSpec(opId);
    }

    public static <K, M, R, JM> StreamTableJoinOperatorSpec<K, M, R, JM> createStreamTableJoinOperatorSpec(TableSpec tableSpec, StreamTableJoinFunction<K, M, R, JM> joinFn, String opId) {
        return new StreamTableJoinOperatorSpec<K, M, R, JM>(tableSpec, joinFn, opId);
    }

    public static <K, V> SendToTableOperatorSpec<K, V> createSendToTableOperatorSpec(TableSpec tableSpec, String opId) {
        return new SendToTableOperatorSpec(tableSpec, opId);
    }

    public static <M> BroadcastOperatorSpec<M> createBroadCastOperatorSpec(OutputStreamImpl<M> outputStream, String opId) {
        return new BroadcastOperatorSpec<M>(outputStream, opId);
    }
}

