/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.MessageStreamImpl;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;

@InterfaceStability.Unstable
public abstract class OperatorSpec<M, OM>
implements Serializable {
    private final String opId;
    private final OpCode opCode;
    private StackTraceElement[] creationStackTrace;
    private final LinkedHashSet<OperatorSpec<OM, ?>> nextOperatorSpecs = new LinkedHashSet();

    final boolean isClone(OperatorSpec other) {
        return this != other && this.getClass().isAssignableFrom(other.getClass()) && this.opCode.equals((Object)other.opCode) && this.opId.equals(other.opId);
    }

    public OperatorSpec(OpCode opCode, String opId) {
        this.opCode = opCode;
        this.opId = opId;
        this.creationStackTrace = Thread.currentThread().getStackTrace();
    }

    public void registerNextOperatorSpec(OperatorSpec<OM, ?> nextOperatorSpec) {
        this.nextOperatorSpecs.add(nextOperatorSpec);
    }

    public Collection<OperatorSpec<OM, ?>> getRegisteredOperatorSpecs() {
        return this.nextOperatorSpecs;
    }

    public final OpCode getOpCode() {
        return this.opCode;
    }

    public final String getOpId() {
        return this.opId;
    }

    public final String getSourceLocation() {
        StackTraceElement element = this.creationStackTrace[5];
        for (int i = 5; i < this.creationStackTrace.length; ++i) {
            if (this.creationStackTrace[i].getClassName().equals(MessageStreamImpl.class.getName()) || this.creationStackTrace[i].getClassName().equals(MessageStream.class.getName())) continue;
            element = this.creationStackTrace[i];
            break;
        }
        return String.format("%s:%s", element.getFileName(), element.getLineNumber());
    }

    public abstract WatermarkFunction getWatermarkFn();

    public abstract ScheduledFunction getScheduledFn();

    public static enum OpCode {
        INPUT,
        MAP,
        FLAT_MAP,
        FILTER,
        SINK,
        SEND_TO,
        JOIN,
        WINDOW,
        MERGE,
        PARTITION_BY,
        OUTPUT,
        BROADCAST;

    }
}

