/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;

class MapOperatorSpec<M, OM>
extends StreamOperatorSpec<M, OM> {
    private final MapFunction<M, OM> mapFn;

    MapOperatorSpec(final MapFunction<M, OM> mapFn, String opId) {
        super(new FlatMapFunction<M, OM>(){

            public Collection<OM> apply(final M message) {
                return new ArrayList<OM>(){
                    {
                        Object r = mapFn.apply(message);
                        if (r != null) {
                            this.add(r);
                        }
                    }
                };
            }

            public void init(Context context) {
                mapFn.init(context);
            }

            public void close() {
                mapFn.close();
            }
        }, OperatorSpec.OpCode.MAP, opId);
        this.mapFn = mapFn;
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        return this.mapFn instanceof WatermarkFunction ? (WatermarkFunction)this.mapFn : null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        return this.mapFn instanceof ScheduledFunction ? (ScheduledFunction)this.mapFn : null;
    }
}

