/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.impl.store.TimestampedValueSerde;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StatefulOperatorSpec;
import org.apache.samza.operators.spec.StoreDescriptor;
import org.apache.samza.serializers.Serde;
import org.apache.samza.util.TimestampedValue;

public class JoinOperatorSpec<K, M, OM, JM>
extends OperatorSpec<Object, JM>
implements StatefulOperatorSpec {
    private final JoinFunction<K, M, OM, JM> joinFn;
    private final long ttlMs;
    private final OperatorSpec<?, M> leftInputOpSpec;
    private final OperatorSpec<?, OM> rightInputOpSpec;
    private final transient Serde<K> keySerde;
    private final transient Serde<TimestampedValue<M>> messageSerde;
    private final transient Serde<TimestampedValue<OM>> otherMessageSerde;

    JoinOperatorSpec(OperatorSpec<?, M> leftInputOpSpec, OperatorSpec<?, OM> rightInputOpSpec, JoinFunction<K, M, OM, JM> joinFn, Serde<K> keySerde, Serde<M> messageSerde, Serde<OM> otherMessageSerde, long ttlMs, String opId) {
        super(OperatorSpec.OpCode.JOIN, opId);
        this.leftInputOpSpec = leftInputOpSpec;
        this.rightInputOpSpec = rightInputOpSpec;
        this.joinFn = joinFn;
        this.keySerde = keySerde;
        this.messageSerde = new TimestampedValueSerde<M>(messageSerde);
        this.otherMessageSerde = new TimestampedValueSerde<OM>(otherMessageSerde);
        this.ttlMs = ttlMs;
    }

    @Override
    public Collection<StoreDescriptor> getStoreDescriptors() {
        String rocksDBStoreFactory = "org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory";
        String leftStoreName = this.getLeftOpId();
        String rightStoreName = this.getRightOpId();
        ImmutableMap leftStoreCustomProps = ImmutableMap.of((Object)String.format("stores.%s.rocksdb.ttl.ms", leftStoreName), (Object)Long.toString(this.ttlMs), (Object)String.format("stores.%s.changelog.kafka.cleanup.policy", leftStoreName), (Object)"delete", (Object)String.format("stores.%s.changelog.kafka.retention.ms", leftStoreName), (Object)Long.toString(this.ttlMs));
        ImmutableMap rightStoreCustomProps = ImmutableMap.of((Object)String.format("stores.%s.rocksdb.ttl.ms", rightStoreName), (Object)Long.toString(this.ttlMs), (Object)String.format("stores.%s.changelog.kafka.cleanup.policy", rightStoreName), (Object)"delete", (Object)String.format("stores.%s.changelog.kafka.retention.ms", rightStoreName), (Object)Long.toString(this.ttlMs));
        return Arrays.asList(new StoreDescriptor(leftStoreName, rocksDBStoreFactory, this.keySerde, this.messageSerde, leftStoreName, (Map<String, String>)leftStoreCustomProps), new StoreDescriptor(rightStoreName, rocksDBStoreFactory, this.keySerde, this.otherMessageSerde, rightStoreName, (Map<String, String>)rightStoreCustomProps));
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        return this.joinFn instanceof WatermarkFunction ? (WatermarkFunction)this.joinFn : null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        return this.joinFn instanceof ScheduledFunction ? (ScheduledFunction)this.joinFn : null;
    }

    public OperatorSpec getLeftInputOpSpec() {
        return this.leftInputOpSpec;
    }

    public OperatorSpec getRightInputOpSpec() {
        return this.rightInputOpSpec;
    }

    public String getLeftOpId() {
        return this.getOpId() + "-L";
    }

    public String getRightOpId() {
        return this.getOpId() + "-R";
    }

    public JoinFunction<K, M, OM, JM> getJoinFn() {
        return this.joinFn;
    }

    public long getTtlMs() {
        return this.ttlMs;
    }
}

