/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.spec;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;

class FilterOperatorSpec<M>
extends StreamOperatorSpec<M, M> {
    private final FilterFunction<M> filterFn;

    FilterOperatorSpec(final FilterFunction<M> filterFn, String opId) {
        super(new FlatMapFunction<M, M>(){

            public Collection<M> apply(final M message) {
                return new ArrayList<M>(){
                    {
                        if (filterFn.apply(message)) {
                            this.add(message);
                        }
                    }
                };
            }

            public void init(Context context) {
                filterFn.init(context);
            }

            public void close() {
                filterFn.close();
            }
        }, OperatorSpec.OpCode.FILTER, opId);
        this.filterFn = filterFn;
    }

    @Override
    public WatermarkFunction getWatermarkFn() {
        return this.filterFn instanceof WatermarkFunction ? (WatermarkFunction)this.filterFn : null;
    }

    @Override
    public ScheduledFunction getScheduledFn() {
        return this.filterFn instanceof ScheduledFunction ? (ScheduledFunction)this.filterFn : null;
    }
}

