/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl.store;

import java.nio.ByteBuffer;
import org.apache.samza.serializers.Serde;
import org.apache.samza.util.TimestampedValue;

public class TimestampedValueSerde<V>
implements Serde<TimestampedValue<V>> {
    private static final int TIMESTAMP_BYTES = 8;
    private final Serde<V> vSerde;

    public TimestampedValueSerde(Serde<V> vSerde) {
        this.vSerde = vSerde;
    }

    public TimestampedValue<V> fromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        byte[] vBytes = new byte[bytes.length - 8];
        bb.get(vBytes, 0, vBytes.length);
        Object v = this.vSerde.fromBytes(vBytes);
        long ts = bb.getLong();
        return new TimestampedValue(v, ts);
    }

    public byte[] toBytes(TimestampedValue<V> tv) {
        byte[] vBytes = this.vSerde.toBytes(tv.getValue());
        int vBytesLength = vBytes != null ? vBytes.length : 0;
        ByteBuffer bb = ByteBuffer.allocate(vBytesLength + 8);
        if (vBytes != null) {
            bb.put(vBytes);
        }
        bb.putLong(tv.getTimestamp());
        return bb.array();
    }
}

