/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl.store;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.samza.operators.impl.store.TimeSeriesKey;
import org.apache.samza.operators.impl.store.TimeSeriesStore;
import org.apache.samza.storage.kv.ClosableIterator;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.util.TimestampedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesStoreImpl<K, V>
implements TimeSeriesStore<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeSeriesStoreImpl.class);
    private final KeyValueStore<TimeSeriesKey<K>, V> kvStore;
    private final AtomicLong seqNum = new AtomicLong();
    private final boolean appendMode;

    public TimeSeriesStoreImpl(KeyValueStore<TimeSeriesKey<K>, V> kvStore, boolean appendMode) {
        this.kvStore = kvStore;
        this.appendMode = appendMode;
    }

    public TimeSeriesStoreImpl(KeyValueStore<TimeSeriesKey<K>, V> kvStore) {
        this(kvStore, true);
    }

    @Override
    public void put(K key, V val, long timestamp) {
        if (this.appendMode) {
            this.seqNum.getAndIncrement();
        }
        TimeSeriesKey<K> timeSeriesKey = new TimeSeriesKey<K>(key, timestamp, this.seqNum.get());
        LOG.trace("Inserting {} -> {} into the store", timeSeriesKey, val);
        this.kvStore.put(timeSeriesKey, val);
    }

    @Override
    public ClosableIterator<TimestampedValue<V>> get(K key, long startTimestamp, long endTimestamp) {
        this.validateRange(startTimestamp, endTimestamp);
        TimeSeriesKey<K> fromKey = new TimeSeriesKey<K>(key, startTimestamp, 0L);
        TimeSeriesKey<K> toKey = new TimeSeriesKey<K>(key, endTimestamp, 0L);
        KeyValueIterator range = this.kvStore.range(fromKey, toKey);
        LOG.trace("Getting entries in the store for {} from {} to {}", new Object[]{key, startTimestamp, endTimestamp});
        return new TimeSeriesStoreIterator(range);
    }

    @Override
    public ClosableIterator<TimestampedValue<V>> get(K key, long startTimestamp, long endTimestamp, int maxValues) {
        ClosableIterator<TimestampedValue<V>> iterator = this.get(key, startTimestamp, endTimestamp);
        return new BoundedClosableIterator<TimestampedValue<V>>(iterator, maxValues);
    }

    @Override
    public ClosableIterator<TimestampedValue<V>> get(K key, long timestamp) {
        return this.get(key, timestamp, timestamp + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key, long startTimestamp, long endTimeStamp) {
        this.validateRange(startTimestamp, endTimeStamp);
        TimeSeriesKey<K> fromKey = new TimeSeriesKey<K>(key, startTimestamp, 0L);
        TimeSeriesKey<K> toKey = new TimeSeriesKey<K>(key, endTimeStamp, 0L);
        LinkedList<Object> keysToDelete = new LinkedList<Object>();
        try (KeyValueIterator range = this.kvStore.range(fromKey, toKey);){
            while (range.hasNext()) {
                keysToDelete.add(((Entry)range.next()).getKey());
            }
        }
        this.kvStore.deleteAll(keysToDelete);
    }

    @Override
    public void remove(K key, long timestamp) {
        this.remove(key, timestamp, timestamp + 1L);
    }

    @Override
    public void flush() {
        this.kvStore.flush();
    }

    @Override
    public void close() {
    }

    private void validateRange(long startTimestamp, long endTimestamp) throws IllegalArgumentException {
        if (startTimestamp < 0L) {
            throw new IllegalArgumentException(String.format("Start timestamp :%d is less than zero", startTimestamp));
        }
        if (endTimestamp < 0L) {
            throw new IllegalArgumentException(String.format("End timestamp :%d is less than zero", endTimestamp));
        }
        if (endTimestamp < startTimestamp) {
            throw new IllegalArgumentException(String.format("End timestamp :%d is less than start timestamp: %d", endTimestamp, startTimestamp));
        }
    }

    private static class BoundedClosableIterator<T>
    implements ClosableIterator<T> {
        private final AtomicInteger currentCount = new AtomicInteger(0);
        private final ClosableIterator<T> wrappedIterator;
        private final int maxCount;

        public BoundedClosableIterator(ClosableIterator<T> wrappedIterator, int maxCount) {
            this.wrappedIterator = wrappedIterator;
            this.maxCount = maxCount;
        }

        public boolean hasNext() {
            return this.wrappedIterator.hasNext() && this.currentCount.get() < this.maxCount;
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentCount.incrementAndGet();
            return (T)this.wrappedIterator.next();
        }

        public void remove() {
            this.wrappedIterator.remove();
        }

        public void close() {
            this.wrappedIterator.close();
        }
    }

    private static class TimeSeriesStoreIterator<K, V>
    implements ClosableIterator<TimestampedValue<V>> {
        private final KeyValueIterator<TimeSeriesKey<K>, V> wrappedIterator;

        public TimeSeriesStoreIterator(KeyValueIterator<TimeSeriesKey<K>, V> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        public void close() {
            this.wrappedIterator.close();
        }

        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        public TimestampedValue<V> next() {
            Entry next = (Entry)this.wrappedIterator.next();
            return new TimestampedValue(next.getValue(), ((TimeSeriesKey)next.getKey()).getTimestamp());
        }

        public void remove() {
            this.wrappedIterator.remove();
        }
    }
}

