/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl.store;

import java.nio.ByteBuffer;
import org.apache.samza.SamzaException;
import org.apache.samza.operators.impl.store.TimeSeriesKey;
import org.apache.samza.serializers.Serde;

public class TimeSeriesKeySerde<K>
implements Serde<TimeSeriesKey<K>> {
    private static final long SEQUENCE_NUM_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int SEQNUM_SIZE = 8;
    private final Serde<K> keySerde;

    public TimeSeriesKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
    }

    public byte[] toBytes(TimeSeriesKey<K> timeSeriesKey) {
        K key = timeSeriesKey.getKey();
        long timestamp = timeSeriesKey.getTimestamp();
        long seqNum = timeSeriesKey.getSeqNum();
        byte[] serializedKey = null;
        if (this.keySerde != null) {
            serializedKey = this.keySerde.toBytes(key);
        }
        int keySize = serializedKey == null ? 0 : serializedKey.length;
        ByteBuffer buf = ByteBuffer.allocate(keySize + 8 + 8);
        if (serializedKey != null) {
            buf.put(serializedKey);
        }
        buf.putLong(timestamp);
        buf.putLong(seqNum & 0xFFFFFFFFFFFFFFL);
        return buf.array();
    }

    public TimeSeriesKey<K> fromBytes(byte[] timeSeriesKeyBytes) {
        ByteBuffer buf = ByteBuffer.wrap(timeSeriesKeyBytes);
        int keySize = timeSeriesKeyBytes.length - 8 - 8;
        Object key = null;
        if (keySize != 0) {
            byte[] keyBytes = new byte[keySize];
            buf.get(keyBytes);
            key = this.keySerde.fromBytes(keyBytes);
        }
        long timeStamp = buf.getLong();
        long seqNum = buf.getLong();
        long version = seqNum & 0xFF00000000000000L;
        if (version != 0L) {
            throw new SamzaException(String.format("Invalid version detected in TimeSeriesKey. Expected Version: %s Actual Version: %s Sequence number: %s", 0, version, seqNum));
        }
        return new TimeSeriesKey<Object>(key, timeStamp, seqNum);
    }
}

