/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl.store;

public class TimeSeriesKey<K> {
    public static final int VERSION = 0;
    private final K key;
    private final long timestamp;
    private final long seqNum;

    public TimeSeriesKey(K k, long time, long seq) {
        this.key = k;
        this.timestamp = time;
        this.seqNum = seq;
    }

    public K getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesKey that = (TimeSeriesKey)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.seqNum != that.seqNum) {
            return false;
        }
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.seqNum ^ this.seqNum >>> 32);
        return result;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public String toString() {
        return String.format("TimeSeriesKey {key: %s timestamp: %s seqNum: %s}", this.key, this.timestamp, this.seqNum);
    }
}

