/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.impl.TriggerScheduler;
import org.apache.samza.operators.impl.store.TimeSeriesStore;
import org.apache.samza.operators.impl.store.TimeSeriesStoreImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.WindowOperatorSpec;
import org.apache.samza.operators.triggers.FiringType;
import org.apache.samza.operators.triggers.RepeatingTriggerImpl;
import org.apache.samza.operators.triggers.TimeTrigger;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.TriggerImpl;
import org.apache.samza.operators.triggers.TriggerImpls;
import org.apache.samza.operators.windows.AccumulationMode;
import org.apache.samza.operators.windows.WindowKey;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.internal.WindowInternal;
import org.apache.samza.operators.windows.internal.WindowType;
import org.apache.samza.storage.kv.ClosableIterator;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.util.Clock;
import org.apache.samza.util.TimestampedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowOperatorImpl<M, K>
extends OperatorImpl<M, WindowPane<K, Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(WindowOperatorImpl.class);
    private final WindowOperatorSpec<M, K, Object> windowOpSpec;
    private final Clock clock;
    private final WindowInternal<M, K, Object> window;
    private final FoldLeftFunction<M, Object> foldLeftFn;
    private final SupplierFunction<Object> initializer;
    private final MapFunction<M, K> keyFn;
    private final TriggerScheduler<K> triggerScheduler;
    private final Map<TriggerKey<K>, TriggerImplHandler> triggers = new HashMap<TriggerKey<K>, TriggerImplHandler>();
    private TimeSeriesStore<K, Object> timeSeriesStore;

    public WindowOperatorImpl(WindowOperatorSpec<M, K, Object> windowOpSpec, Clock clock) {
        this.windowOpSpec = windowOpSpec;
        this.clock = clock;
        this.window = windowOpSpec.getWindow();
        this.foldLeftFn = this.window.getFoldLeftFunction();
        this.initializer = this.window.getInitializer();
        this.keyFn = this.window.getKeyExtractor();
        this.triggerScheduler = new TriggerScheduler(clock);
    }

    @Override
    protected void handleInit(Context context) {
        KeyValueStore store = context.getTaskContext().getStore(this.windowOpSpec.getOpId());
        if (this.initializer != null) {
            this.initializer.init(context);
        }
        if (this.keyFn != null) {
            this.keyFn.init(context);
        }
        if (this.foldLeftFn != null) {
            this.foldLeftFn.init(context);
            this.timeSeriesStore = new TimeSeriesStoreImpl<K, Object>(store, false);
        } else {
            this.timeSeriesStore = new TimeSeriesStoreImpl<K, Object>(store, true);
        }
    }

    @Override
    public Collection<WindowPane<K, Object>> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        Optional maybeTriggeredPane;
        TriggerImplHandler triggerImplHandler;
        TriggerKey<Object> triggerKey;
        LOG.trace("Processing message envelope: {}", message);
        ArrayList<WindowPane<K, Object>> results = new ArrayList<WindowPane<K, Object>>();
        Object key = this.keyFn != null ? this.keyFn.apply(message) : null;
        long timestamp = this.getWindowTimestamp(message);
        if (this.foldLeftFn == null) {
            this.timeSeriesStore.put(key, message, timestamp);
        } else {
            List<Object> existingState = this.getValues(key, timestamp);
            Preconditions.checkState((existingState.size() <= 1 ? 1 : 0) != 0, (Object)String.format("WindowState for aggregating windows must not contain more than one entry per window. Current size: %s", existingState.size()));
            if (existingState.size() == 0) {
                LOG.trace("No existing state found for key {} Invoking initializer.", key);
            }
            Object oldVal = existingState.size() == 0 ? this.initializer.get() : existingState.get(0);
            Object aggregatedValue = this.foldLeftFn.apply(message, oldVal);
            this.timeSeriesStore.put(key, aggregatedValue, timestamp);
        }
        if (this.window.getEarlyTrigger() != null) {
            triggerKey = new TriggerKey<Object>(FiringType.EARLY, key, timestamp);
            triggerImplHandler = this.getOrCreateTriggerImplHandler(triggerKey, this.window.getEarlyTrigger());
            maybeTriggeredPane = triggerImplHandler.onMessage(triggerKey, message, collector, coordinator);
            maybeTriggeredPane.ifPresent(results::add);
        }
        if (this.window.getDefaultTrigger() != null) {
            triggerKey = new TriggerKey<Object>(FiringType.DEFAULT, key, timestamp);
            triggerImplHandler = this.getOrCreateTriggerImplHandler(triggerKey, this.window.getDefaultTrigger());
            maybeTriggeredPane = triggerImplHandler.onMessage(triggerKey, message, collector, coordinator);
            maybeTriggeredPane.ifPresent(results::add);
        }
        return results;
    }

    @Override
    public Collection<WindowPane<K, Object>> handleTimer(MessageCollector collector, TaskCoordinator coordinator) {
        LOG.trace("Processing time triggers");
        ArrayList<WindowPane<K, Object>> results = new ArrayList<WindowPane<K, Object>>();
        List<TriggerKey<K>> keys = this.triggerScheduler.runPendingCallbacks();
        for (TriggerKey<K> key : keys) {
            TriggerImplHandler triggerImplHandler = this.triggers.get(key);
            if (triggerImplHandler == null) continue;
            Optional maybeTriggeredPane = triggerImplHandler.onTimer(key, collector, coordinator);
            maybeTriggeredPane.ifPresent(results::add);
        }
        LOG.trace("Triggered panes: " + results.size());
        return results;
    }

    @Override
    protected OperatorSpec<M, WindowPane<K, Object>> getOperatorSpec() {
        return this.windowOpSpec;
    }

    @Override
    protected Collection<WindowPane<K, Object>> handleEndOfStream(MessageCollector collector, TaskCoordinator coordinator) {
        ArrayList<WindowPane<K, Object>> results = new ArrayList<WindowPane<K, Object>>();
        HashSet<TriggerKey<K>> triggerKeys = new HashSet<TriggerKey<K>>(this.triggers.keySet());
        for (TriggerKey triggerKey : triggerKeys) {
            Optional<WindowPane<K, Object>> triggerResult = this.onTriggerFired(triggerKey, collector, coordinator);
            triggerResult.ifPresent(results::add);
        }
        return results;
    }

    @Override
    protected void handleClose() {
        if (this.foldLeftFn != null) {
            this.foldLeftFn.close();
        }
        if (this.timeSeriesStore != null) {
            this.timeSeriesStore.close();
        }
        if (this.initializer != null) {
            this.initializer.close();
        }
        if (this.keyFn != null) {
            this.keyFn.close();
        }
    }

    private TriggerImplHandler getOrCreateTriggerImplHandler(TriggerKey<K> triggerKey, Trigger<M> trigger) {
        TriggerImplHandler wrapper = this.triggers.get(triggerKey);
        if (wrapper != null) {
            LOG.trace("Returning existing trigger wrapper for {}", triggerKey);
            return wrapper;
        }
        LOG.trace("Creating a new trigger wrapper for {}", triggerKey);
        TriggerImpl<M, K> triggerImpl = TriggerImpls.createTriggerImpl(trigger, this.clock, triggerKey);
        wrapper = new TriggerImplHandler(triggerKey, triggerImpl);
        this.triggers.put(triggerKey, wrapper);
        return wrapper;
    }

    private Optional<WindowPane<K, Object>> onTriggerFired(TriggerKey<K> triggerKey, MessageCollector collector, TaskCoordinator coordinator) {
        LOG.trace("Trigger key {} fired.", triggerKey);
        TriggerImplHandler wrapper = this.triggers.get(triggerKey);
        long timestamp = triggerKey.getTimestamp();
        K key = triggerKey.getKey();
        List<Object> existingState = this.getValues(key, timestamp);
        if (existingState == null || existingState.size() == 0) {
            LOG.trace("No state found for triggerKey: {}", triggerKey);
            return Optional.empty();
        }
        List<Object> windowVal = this.window.getFoldLeftFunction() == null ? existingState : existingState.get(0);
        WindowPane<K, Object> paneOutput = this.computePaneOutput(triggerKey, windowVal);
        if (this.window.getAccumulationMode() == AccumulationMode.DISCARDING) {
            LOG.trace("Clearing state for trigger key: {}", triggerKey);
            this.timeSeriesStore.remove(key, timestamp);
        }
        if (triggerKey.getType() == FiringType.DEFAULT) {
            LOG.trace("Default trigger fired. Canceling triggers for {}", triggerKey);
            this.cancelTrigger(triggerKey, true);
            this.cancelTrigger(new TriggerKey<K>(FiringType.EARLY, triggerKey.getKey(), triggerKey.getTimestamp()), true);
            this.timeSeriesStore.remove(key, timestamp);
        }
        if (triggerKey.getType() == FiringType.EARLY && !wrapper.isRepeating()) {
            this.cancelTrigger(triggerKey, false);
        }
        return Optional.of(paneOutput);
    }

    private WindowPane<K, Object> computePaneOutput(TriggerKey<K> triggerKey, Object windowVal) {
        WindowKey windowKey = new WindowKey(triggerKey.getKey(), Long.toString(triggerKey.getTimestamp()));
        WindowPane paneOutput = new WindowPane(windowKey, windowVal, this.window.getAccumulationMode(), triggerKey.getType());
        LOG.trace("Emitting pane output for trigger key {}", triggerKey);
        return paneOutput;
    }

    private void cancelTrigger(TriggerKey<K> triggerKey, boolean shouldRemove) {
        TriggerImplHandler triggerImplHandler = this.triggers.get(triggerKey);
        if (triggerImplHandler != null) {
            triggerImplHandler.cancel();
        }
        if (shouldRemove && triggerKey != null) {
            this.triggers.remove(triggerKey);
        }
    }

    private long getWindowTimestamp(M message) {
        if (this.window.getWindowType() == WindowType.TUMBLING) {
            long triggerDurationMs = ((TimeTrigger)this.window.getDefaultTrigger()).getDuration().toMillis();
            long now = this.clock.currentTimeMillis();
            long timestamp = now - now % triggerDurationMs;
            return timestamp;
        }
        Object key = this.keyFn.apply(message);
        ClosableIterator<TimestampedValue<Object>> iterator = this.timeSeriesStore.get(key, 0L, Long.MAX_VALUE, 1);
        List<TimestampedValue<Object>> timestampedValues = WindowOperatorImpl.toList(iterator);
        long timestamp = timestampedValues.isEmpty() ? this.clock.currentTimeMillis() : timestampedValues.get(0).getTimestamp();
        return timestamp;
    }

    private List<Object> getValues(K key, long timestamp) {
        ClosableIterator<TimestampedValue<Object>> iterator = this.timeSeriesStore.get(key, timestamp);
        List<TimestampedValue<Object>> timestampedValues = WindowOperatorImpl.toList(iterator);
        List<Object> values = timestampedValues.stream().map(element -> element.getValue()).collect(Collectors.toList());
        LOG.trace("Returning {} for key {} and timestamp {}", new Object[]{values, key, timestamp});
        return values;
    }

    static <V> List<V> toList(ClosableIterator<V> iterator) {
        Preconditions.checkNotNull(iterator);
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            while (iterator.hasNext()) {
                values.add(iterator.next());
            }
        }
        finally {
            iterator.close();
        }
        return Collections.unmodifiableList(values);
    }

    private class TriggerImplHandler {
        private final TriggerImpl<M, K> impl;
        private boolean isCancelled = false;

        public TriggerImplHandler(TriggerKey<K> key, TriggerImpl<M, K> impl) {
            this.impl = impl;
        }

        public Optional<WindowPane<K, Object>> onMessage(TriggerKey<K> triggerKey, M message, MessageCollector collector, TaskCoordinator coordinator) {
            if (!this.isCancelled) {
                LOG.trace("Forwarding callbacks for {}", message);
                this.impl.onMessage(message, WindowOperatorImpl.this.triggerScheduler);
                if (this.impl.shouldFire()) {
                    if (this.impl instanceof RepeatingTriggerImpl) {
                        ((RepeatingTriggerImpl)this.impl).clear();
                    }
                    return WindowOperatorImpl.this.onTriggerFired(triggerKey, collector, coordinator);
                }
            }
            return Optional.empty();
        }

        public Optional<WindowPane<K, Object>> onTimer(TriggerKey<K> key, MessageCollector collector, TaskCoordinator coordinator) {
            if (this.impl.shouldFire() && !this.isCancelled) {
                LOG.trace("Triggering timer triggers");
                if (this.impl instanceof RepeatingTriggerImpl) {
                    ((RepeatingTriggerImpl)this.impl).clear();
                }
                return WindowOperatorImpl.this.onTriggerFired(key, collector, coordinator);
            }
            return Optional.empty();
        }

        public void cancel() {
            this.impl.cancel();
            this.isCancelled = true;
        }

        public boolean isRepeating() {
            return this.impl instanceof RepeatingTriggerImpl;
        }
    }
}

