/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.operators.impl.WatermarkMetrics;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.WatermarkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatermarkStates {
    private static final Logger LOG = LoggerFactory.getLogger(WatermarkStates.class);
    public static final long WATERMARK_NOT_EXIST = -1L;
    private final Map<SystemStreamPartition, WatermarkState> watermarkStates;
    private final List<SystemStreamPartition> intermediateSsps;
    private final WatermarkMetrics watermarkMetrics;

    WatermarkStates(Set<SystemStreamPartition> ssps, Map<SystemStream, Integer> producerTaskCounts, MetricsRegistry metricsRegistry) {
        HashMap states = new HashMap();
        ArrayList intSsps = new ArrayList();
        ssps.forEach(ssp -> {
            int producerCount = producerTaskCounts.getOrDefault(ssp.getSystemStream(), 0);
            states.put(ssp, new WatermarkState(producerCount));
            if (producerCount != 0) {
                intSsps.add(ssp);
            }
        });
        this.watermarkStates = Collections.unmodifiableMap(states);
        this.watermarkMetrics = new WatermarkMetrics(metricsRegistry);
        this.intermediateSsps = Collections.unmodifiableList(intSsps);
    }

    void update(WatermarkMessage watermarkMessage, SystemStreamPartition ssp) {
        WatermarkState state = this.watermarkStates.get(ssp);
        if (state != null) {
            state.update(watermarkMessage.getTimestamp(), watermarkMessage.getTaskName());
        } else {
            LOG.error("SSP {} doesn't have watermark states", (Object)ssp);
        }
    }

    long getWatermark(SystemStream systemStream) {
        return this.watermarkStates.entrySet().stream().filter(entry -> ((SystemStreamPartition)entry.getKey()).getSystemStream().equals((Object)systemStream)).map(entry -> ((WatermarkState)entry.getValue()).getWatermarkTime()).min(Long::compare).orElse(-1L);
    }

    long getWatermarkPerSSP(SystemStreamPartition ssp) {
        return this.watermarkStates.get(ssp).getWatermarkTime();
    }

    void updateAggregateMetric(SystemStreamPartition ssp, long time) {
        if (this.intermediateSsps.contains(ssp)) {
            this.watermarkMetrics.setAggregateTime(ssp, time);
        }
    }

    private static final class WatermarkState {
        private final int expectedTotal;
        private final Map<String, Long> timestamps = new HashMap<String, Long>();
        private volatile long watermarkTime = -1L;

        WatermarkState(int expectedTotal) {
            this.expectedTotal = expectedTotal;
        }

        synchronized void update(long timestamp, String taskName) {
            if (taskName != null) {
                Long ts = this.timestamps.get(taskName);
                if (ts != null && ts > timestamp) {
                    LOG.warn(String.format("Incoming watermark %s is smaller than existing watermark %s for upstream task %s", timestamp, ts, taskName));
                } else {
                    this.timestamps.put(taskName, timestamp);
                }
            }
            if (taskName == null) {
                this.watermarkTime = Math.max(this.watermarkTime, timestamp);
            } else if (this.timestamps.size() == this.expectedTotal) {
                Optional<Long> min = this.timestamps.values().stream().min(Long::compare);
                this.watermarkTime = min.orElse(timestamp);
            }
        }

        long getWatermarkTime() {
            return this.watermarkTime;
        }
    }
}

