/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.MetricsBase;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemStreamPartition;

class WatermarkMetrics
extends MetricsBase {
    private final Map<SystemStreamPartition, Gauge<Long>> aggregates = new ConcurrentHashMap<SystemStreamPartition, Gauge<Long>>();

    WatermarkMetrics(MetricsRegistry registry) {
        super("watermark-", registry);
    }

    void setAggregateTime(SystemStreamPartition systemStreamPartition, long time) {
        Gauge aggregate = this.aggregates.computeIfAbsent(systemStreamPartition, ssp -> this.newGauge(String.format("%s-%s-aggr-watermark", ssp.getStream(), ssp.getPartition().getPartitionId()), 0L));
        aggregate.set((Object)time);
    }
}

