/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.samza.operators.impl.TriggerKey;
import org.apache.samza.operators.triggers.Cancellable;
import org.apache.samza.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerScheduler<WK> {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerScheduler.class);
    private final PriorityQueue<TriggerCallbackState<WK>> pendingCallbacks = new PriorityQueue();
    private final Clock clock;

    public TriggerScheduler(Clock clock) {
        this.clock = clock;
    }

    public Cancellable scheduleCallback(Runnable runnable, long scheduledTimeMs, TriggerKey<WK> triggerKey) {
        TriggerCallbackState timerState = new TriggerCallbackState(triggerKey, runnable, scheduledTimeMs);
        this.pendingCallbacks.add(timerState);
        LOG.trace("Scheduled a new callback: {} at {} for triggerKey {}", new Object[]{runnable, scheduledTimeMs, triggerKey});
        return timerState;
    }

    public List<TriggerKey<WK>> runPendingCallbacks() {
        TriggerCallbackState<WK> state;
        ArrayList<TriggerKey<WK>> keys = new ArrayList<TriggerKey<WK>>();
        long now = this.clock.currentTimeMillis();
        while ((state = this.pendingCallbacks.peek()) != null && ((TriggerCallbackState)state).getScheduledTimeMs() <= now) {
            this.pendingCallbacks.remove();
            ((TriggerCallbackState)state).getCallback().run();
            TriggerKey key = ((TriggerCallbackState)state).getTriggerKey();
            keys.add(key);
        }
        return keys;
    }

    private class TriggerCallbackState<WK>
    implements Comparable<TriggerCallbackState<WK>>,
    Cancellable {
        private final TriggerKey<WK> triggerKey;
        private final Runnable callback;
        private final long scheduledTimeMs;

        private TriggerCallbackState(TriggerKey<WK> triggerKey, Runnable callback, long scheduledTimeMs) {
            this.triggerKey = triggerKey;
            this.callback = callback;
            this.scheduledTimeMs = scheduledTimeMs;
        }

        private Runnable getCallback() {
            return this.callback;
        }

        private long getScheduledTimeMs() {
            return this.scheduledTimeMs;
        }

        private TriggerKey<WK> getTriggerKey() {
            return this.triggerKey;
        }

        @Override
        public int compareTo(TriggerCallbackState<WK> other) {
            return Long.compare(this.scheduledTimeMs, other.scheduledTimeMs);
        }

        @Override
        public boolean cancel() {
            LOG.trace("Cancelled a callback: {} at {} for triggerKey {}", new Object[]{this.callback, this.scheduledTimeMs, this.triggerKey});
            return TriggerScheduler.this.pendingCallbacks.remove(this);
        }
    }
}

