/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import org.apache.samza.operators.triggers.FiringType;

public class TriggerKey<K> {
    private final FiringType type;
    private final K key;
    private final long timestamp;

    public TriggerKey(FiringType type, K key, long timestamp) {
        if (type == null) {
            throw new IllegalArgumentException("Firing type cannot be null");
        }
        this.type = type;
        this.key = key;
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerKey that = (TriggerKey)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public K getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public FiringType getType() {
        return this.type;
    }

    public String toString() {
        return String.format("TriggerKey: {type=%s, key=%s}", this.type, this.key);
    }
}

