/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.table.ReadableTable;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class StreamTableJoinOperatorImpl<K, M, R extends KV, JM>
extends OperatorImpl<M, JM> {
    private final StreamTableJoinOperatorSpec<K, M, R, JM> joinOpSpec;
    private final ReadableTable<K, ?> table;

    StreamTableJoinOperatorImpl(StreamTableJoinOperatorSpec<K, M, R, JM> joinOpSpec, Context context) {
        this.joinOpSpec = joinOpSpec;
        this.table = (ReadableTable)context.getTaskContext().getTable(joinOpSpec.getTableSpec().getId());
    }

    @Override
    protected void handleInit(Context context) {
        this.joinOpSpec.getJoinFn().init(context);
    }

    @Override
    public Collection<JM> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        Object key = this.joinOpSpec.getJoinFn().getMessageKey(message);
        Object recordValue = this.table.get(key);
        KV record = recordValue != null ? KV.of((Object)key, (Object)recordValue) : null;
        Object output = this.joinOpSpec.getJoinFn().apply(message, (Object)record);
        return output != null ? Collections.singletonList(output) : Collections.emptyList();
    }

    @Override
    protected void handleClose() {
        this.joinOpSpec.getJoinFn().close();
    }

    @Override
    protected OperatorSpec<M, JM> getOperatorSpec() {
        return this.joinOpSpec;
    }
}

