/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class StreamOperatorImpl<M, RM>
extends OperatorImpl<M, RM> {
    private final StreamOperatorSpec<M, RM> streamOpSpec;
    private final FlatMapFunction<M, RM> transformFn;

    StreamOperatorImpl(StreamOperatorSpec<M, RM> streamOpSpec) {
        this.streamOpSpec = streamOpSpec;
        this.transformFn = streamOpSpec.getTransformFn();
    }

    @Override
    protected void handleInit(Context context) {
        this.transformFn.init(context);
    }

    @Override
    public Collection<RM> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        return this.transformFn.apply(message);
    }

    @Override
    protected void handleClose() {
        this.transformFn.close();
    }

    @Override
    protected OperatorSpec<M, RM> getOperatorSpec() {
        return this.streamOpSpec;
    }
}

