/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.SinkFunction;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.SinkOperatorSpec;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class SinkOperatorImpl<M>
extends OperatorImpl<M, Void> {
    private final SinkOperatorSpec<M> sinkOpSpec;
    private final SinkFunction<M> sinkFn;

    SinkOperatorImpl(SinkOperatorSpec<M> sinkOpSpec) {
        this.sinkOpSpec = sinkOpSpec;
        this.sinkFn = sinkOpSpec.getSinkFn();
    }

    @Override
    protected void handleInit(Context context) {
        this.sinkFn.init(context);
    }

    @Override
    public Collection<Void> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        this.sinkFn.apply(message, collector, coordinator);
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
        this.sinkFn.close();
    }

    @Override
    protected OperatorSpec<M, Void> getOperatorSpec() {
        return this.sinkOpSpec;
    }
}

