/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.SendToTableOperatorSpec;
import org.apache.samza.table.ReadWriteTable;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

public class SendToTableOperatorImpl<K, V>
extends OperatorImpl<KV<K, V>, Void> {
    private final SendToTableOperatorSpec<K, V> sendToTableOpSpec;
    private final ReadWriteTable<K, V> table;

    SendToTableOperatorImpl(SendToTableOperatorSpec<K, V> sendToTableOpSpec, Context context) {
        this.sendToTableOpSpec = sendToTableOpSpec;
        this.table = (ReadWriteTable)context.getTaskContext().getTable(sendToTableOpSpec.getTableSpec().getId());
    }

    @Override
    protected void handleInit(Context context) {
    }

    @Override
    protected Collection<Void> handleMessage(KV<K, V> message, MessageCollector collector, TaskCoordinator coordinator) {
        this.table.put(message.getKey(), message.getValue());
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
        this.table.close();
    }

    @Override
    protected OperatorSpec<KV<K, V>, Void> getOperatorSpec() {
        return this.sendToTableOpSpec;
    }
}

