/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.context.TaskContextImpl;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.impl.ControlMessageSender;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.PartitionByOperatorSpec;
import org.apache.samza.system.ControlMessage;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.WatermarkMessage;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class PartitionByOperatorImpl<M, K, V>
extends OperatorImpl<M, Void> {
    private final PartitionByOperatorSpec<M, K, V> partitionByOpSpec;
    private final SystemStream systemStream;
    private final MapFunction<? super M, ? extends K> keyFunction;
    private final MapFunction<? super M, ? extends V> valueFunction;
    private final String taskName;
    private final ControlMessageSender controlMessageSender;

    PartitionByOperatorImpl(PartitionByOperatorSpec<M, K, V> partitionByOpSpec, SystemStream systemStream, Context context) {
        this.partitionByOpSpec = partitionByOpSpec;
        this.systemStream = systemStream;
        this.keyFunction = partitionByOpSpec.getKeyFunction();
        this.valueFunction = partitionByOpSpec.getValueFunction();
        this.taskName = context.getTaskContext().getTaskModel().getTaskName().getTaskName();
        StreamMetadataCache streamMetadataCache = ((TaskContextImpl)context.getTaskContext()).getStreamMetadataCache();
        this.controlMessageSender = new ControlMessageSender(streamMetadataCache);
    }

    @Override
    protected void handleInit(Context context) {
        this.keyFunction.init(context);
        this.valueFunction.init(context);
    }

    @Override
    public Collection<Void> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        Object key = this.keyFunction.apply(message);
        Object value = this.valueFunction.apply(message);
        Long partitionKey = key == null ? Long.valueOf(0L) : null;
        collector.send(new OutgoingMessageEnvelope(this.systemStream, (Object)partitionKey, key, value));
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
        this.keyFunction.close();
        this.valueFunction.close();
    }

    @Override
    protected OperatorSpec<M, Void> getOperatorSpec() {
        return this.partitionByOpSpec;
    }

    @Override
    protected Collection<Void> handleEndOfStream(MessageCollector collector, TaskCoordinator coordinator) {
        this.sendControlMessage((ControlMessage)new EndOfStreamMessage(this.taskName), collector);
        return Collections.emptyList();
    }

    @Override
    protected Collection<Void> handleWatermark(long watermark, MessageCollector collector, TaskCoordinator coordinator) {
        this.sendControlMessage((ControlMessage)new WatermarkMessage(watermark, this.taskName), collector);
        return Collections.emptyList();
    }

    private void sendControlMessage(ControlMessage message, MessageCollector collector) {
        this.controlMessageSender.send(message, this.systemStream, collector);
    }
}

