/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.SamzaException;
import org.apache.samza.context.Context;
import org.apache.samza.operators.functions.PartialJoinFunction;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.util.Clock;
import org.apache.samza.util.TimestampedValue;

class PartialJoinOperatorImpl<K, M, OM, JM>
extends OperatorImpl<M, JM> {
    private final JoinOperatorSpec<K, M, OM, JM> joinOpSpec;
    private final boolean isLeftSide;
    private final PartialJoinFunction<K, M, OM, JM> thisPartialJoinFn;
    private final PartialJoinFunction<K, OM, M, JM> otherPartialJoinFn;
    private final long ttlMs;
    private final Clock clock;

    PartialJoinOperatorImpl(JoinOperatorSpec<K, M, OM, JM> joinOpSpec, boolean isLeftSide, PartialJoinFunction<K, M, OM, JM> thisPartialJoinFn, PartialJoinFunction<K, OM, M, JM> otherPartialJoinFn, Clock clock) {
        this.joinOpSpec = joinOpSpec;
        this.isLeftSide = isLeftSide;
        this.thisPartialJoinFn = thisPartialJoinFn;
        this.otherPartialJoinFn = otherPartialJoinFn;
        this.ttlMs = joinOpSpec.getTtlMs();
        this.clock = clock;
    }

    @Override
    protected void handleInit(Context context) {
        this.thisPartialJoinFn.init(context);
    }

    @Override
    public Collection<JM> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        try {
            KeyValueStore<K, TimestampedValue<M>> thisState = this.thisPartialJoinFn.getState();
            KeyValueStore<K, TimestampedValue<OM>> otherState = this.otherPartialJoinFn.getState();
            K key = this.thisPartialJoinFn.getKey(message);
            thisState.put(key, (Object)new TimestampedValue(message, this.clock.currentTimeMillis()));
            TimestampedValue otherMessage = (TimestampedValue)otherState.get(key);
            long now = this.clock.currentTimeMillis();
            if (otherMessage != null && otherMessage.getTimestamp() > now - this.ttlMs) {
                JM joinResult = this.thisPartialJoinFn.apply(message, otherMessage.getValue());
                return Collections.singletonList(joinResult);
            }
        }
        catch (Exception e) {
            throw new SamzaException("Error handling message in PartialJoinOperatorImpl " + this.getOpImplId(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
        this.thisPartialJoinFn.close();
    }

    @Override
    protected OperatorSpec<M, JM> getOperatorSpec() {
        return this.joinOpSpec;
    }

    @Override
    protected String getOpImplId() {
        return this.isLeftSide ? this.joinOpSpec.getLeftOpId() : this.joinOpSpec.getRightOpId();
    }
}

