/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputOperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemStream;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class OutputOperatorImpl<M>
extends OperatorImpl<M, Void> {
    private final OutputOperatorSpec<M> outputOpSpec;
    private final OutputStreamImpl<M> outputStream;
    private final SystemStream systemStream;

    OutputOperatorImpl(OutputOperatorSpec<M> outputOpSpec, SystemStream systemStream) {
        this.outputOpSpec = outputOpSpec;
        this.outputStream = outputOpSpec.getOutputStream();
        this.systemStream = systemStream;
    }

    @Override
    protected void handleInit(Context context) {
    }

    @Override
    public Collection<Void> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        Object value;
        Object key;
        if (this.outputStream.isKeyed()) {
            key = ((KV)message).getKey();
            value = ((KV)message).getValue();
        } else {
            key = null;
            value = message;
        }
        collector.send(new OutgoingMessageEnvelope(this.systemStream, null, key, value));
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
    }

    @Override
    protected OperatorSpec<M, Void> getOperatorSpec() {
        return this.outputOpSpec;
    }
}

