/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.samza.config.Config;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.context.Context;
import org.apache.samza.context.TaskContextImpl;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.OperatorSpecGraph;
import org.apache.samza.operators.Scheduler;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.PartialJoinFunction;
import org.apache.samza.operators.impl.BroadcastOperatorImpl;
import org.apache.samza.operators.impl.EndOfStreamStates;
import org.apache.samza.operators.impl.InputOperatorImpl;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.impl.OutputOperatorImpl;
import org.apache.samza.operators.impl.PartialJoinOperatorImpl;
import org.apache.samza.operators.impl.PartitionByOperatorImpl;
import org.apache.samza.operators.impl.SendToTableOperatorImpl;
import org.apache.samza.operators.impl.SinkOperatorImpl;
import org.apache.samza.operators.impl.StreamOperatorImpl;
import org.apache.samza.operators.impl.StreamTableJoinOperatorImpl;
import org.apache.samza.operators.impl.WatermarkStates;
import org.apache.samza.operators.impl.WindowOperatorImpl;
import org.apache.samza.operators.spec.BroadcastOperatorSpec;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputOperatorSpec;
import org.apache.samza.operators.spec.PartitionByOperatorSpec;
import org.apache.samza.operators.spec.SendToTableOperatorSpec;
import org.apache.samza.operators.spec.SinkOperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.operators.spec.WindowOperatorSpec;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.Clock;
import org.apache.samza.util.TimestampedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorImplGraph {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorImplGraph.class);
    private final Map<String, OperatorImpl> operatorImpls = new LinkedHashMap<String, OperatorImpl>();
    private final Map<SystemStream, InputOperatorImpl> inputOperators = new HashMap<SystemStream, InputOperatorImpl>();
    private final Map<String, KV<PartialJoinOperatorImpl, PartialJoinOperatorImpl>> joinOpImpls = new HashMap<String, KV<PartialJoinOperatorImpl, PartialJoinOperatorImpl>>();
    private final Clock clock;

    public OperatorImplGraph(OperatorSpecGraph specGraph, Context context, Clock clock) {
        this.clock = clock;
        StreamConfig streamConfig = new StreamConfig(context.getJobContext().getConfig());
        TaskContextImpl taskContext = (TaskContextImpl)context.getTaskContext();
        Map<SystemStream, Integer> producerTaskCounts = this.hasIntermediateStreams(specGraph) ? OperatorImplGraph.getProducerTaskCountForIntermediateStreams(OperatorImplGraph.getStreamToConsumerTasks(taskContext.getJobModel()), OperatorImplGraph.getIntermediateToInputStreamsMap(specGraph, streamConfig)) : Collections.EMPTY_MAP;
        producerTaskCounts.forEach((stream, count) -> LOG.info("{} has {} producer tasks.", stream, count));
        taskContext.registerObject(EndOfStreamStates.class.getName(), new EndOfStreamStates(taskContext.getTaskModel().getSystemStreamPartitions(), producerTaskCounts));
        taskContext.registerObject(WatermarkStates.class.getName(), new WatermarkStates(taskContext.getTaskModel().getSystemStreamPartitions(), producerTaskCounts, context.getContainerContext().getContainerMetricsRegistry()));
        specGraph.getInputOperators().forEach((streamId, inputOpSpec) -> {
            SystemStream systemStream = streamConfig.streamIdToSystemStream((String)streamId);
            InputOperatorImpl inputOperatorImpl = (InputOperatorImpl)this.createAndRegisterOperatorImpl(null, (OperatorSpec)inputOpSpec, systemStream, context);
            this.inputOperators.put(systemStream, inputOperatorImpl);
        });
    }

    public InputOperatorImpl getInputOperator(SystemStream systemStream) {
        return this.inputOperators.get(systemStream);
    }

    public void close() {
        ArrayList<OperatorImpl> initializationOrder = new ArrayList<OperatorImpl>(this.operatorImpls.values());
        List finalizationOrder = Lists.reverse(initializationOrder);
        finalizationOrder.forEach(OperatorImpl::close);
    }

    public Collection<InputOperatorImpl> getAllInputOperators() {
        return Collections.unmodifiableCollection(this.inputOperators.values());
    }

    private OperatorImpl createAndRegisterOperatorImpl(OperatorSpec prevOperatorSpec, OperatorSpec operatorSpec, SystemStream inputStream, Context context) {
        if (!this.operatorImpls.containsKey(operatorSpec.getOpId()) || operatorSpec instanceof JoinOperatorSpec) {
            OperatorImpl operatorImpl = this.createOperatorImpl(prevOperatorSpec, operatorSpec, context);
            operatorImpl.init(context);
            operatorImpl.registerInputStream(inputStream);
            if (operatorSpec.getScheduledFn() != null) {
                Scheduler scheduler2 = operatorImpl.createOperatorScheduler();
                operatorSpec.getScheduledFn().schedule(scheduler2);
            }
            this.operatorImpls.put(operatorImpl.getOpImplId(), operatorImpl);
            Collection registeredSpecs = operatorSpec.getRegisteredOperatorSpecs();
            registeredSpecs.forEach(registeredSpec -> {
                LOG.debug("Creating operator {} with opCode: {}", (Object)registeredSpec.getOpId(), (Object)registeredSpec.getOpCode());
                OperatorImpl nextImpl = this.createAndRegisterOperatorImpl(operatorSpec, (OperatorSpec)registeredSpec, inputStream, context);
                operatorImpl.registerNextOperator(nextImpl);
            });
            return operatorImpl;
        }
        OperatorImpl operatorImpl = this.operatorImpls.get(operatorSpec.getOpId());
        operatorImpl.registerInputStream(inputStream);
        Collection registeredSpecs = operatorSpec.getRegisteredOperatorSpecs();
        registeredSpecs.forEach(registeredSpec -> this.createAndRegisterOperatorImpl(operatorSpec, (OperatorSpec)registeredSpec, inputStream, context));
        return operatorImpl;
    }

    OperatorImpl createOperatorImpl(OperatorSpec prevOperatorSpec, OperatorSpec operatorSpec, Context context) {
        Config config = context.getJobContext().getConfig();
        StreamConfig streamConfig = new StreamConfig(config);
        if (operatorSpec instanceof InputOperatorSpec) {
            return new InputOperatorImpl((InputOperatorSpec)operatorSpec);
        }
        if (operatorSpec instanceof StreamOperatorSpec) {
            return new StreamOperatorImpl((StreamOperatorSpec)operatorSpec);
        }
        if (operatorSpec instanceof SinkOperatorSpec) {
            return new SinkOperatorImpl((SinkOperatorSpec)operatorSpec);
        }
        if (operatorSpec instanceof OutputOperatorSpec) {
            String streamId = ((OutputOperatorSpec)operatorSpec).getOutputStream().getStreamId();
            SystemStream systemStream = streamConfig.streamIdToSystemStream(streamId);
            return new OutputOperatorImpl((OutputOperatorSpec)operatorSpec, systemStream);
        }
        if (operatorSpec instanceof PartitionByOperatorSpec) {
            String streamId = ((PartitionByOperatorSpec)operatorSpec).getOutputStream().getStreamId();
            SystemStream systemStream = streamConfig.streamIdToSystemStream(streamId);
            return new PartitionByOperatorImpl((PartitionByOperatorSpec)operatorSpec, systemStream, context);
        }
        if (operatorSpec instanceof WindowOperatorSpec) {
            return new WindowOperatorImpl((WindowOperatorSpec)operatorSpec, this.clock);
        }
        if (operatorSpec instanceof JoinOperatorSpec) {
            return this.getOrCreatePartialJoinOpImpls((JoinOperatorSpec)operatorSpec, prevOperatorSpec.equals(((JoinOperatorSpec)operatorSpec).getLeftInputOpSpec()), this.clock);
        }
        if (operatorSpec instanceof StreamTableJoinOperatorSpec) {
            return new StreamTableJoinOperatorImpl((StreamTableJoinOperatorSpec)operatorSpec, context);
        }
        if (operatorSpec instanceof SendToTableOperatorSpec) {
            return new SendToTableOperatorImpl((SendToTableOperatorSpec)operatorSpec, context);
        }
        if (operatorSpec instanceof BroadcastOperatorSpec) {
            String streamId = ((BroadcastOperatorSpec)operatorSpec).getOutputStream().getStreamId();
            SystemStream systemStream = streamConfig.streamIdToSystemStream(streamId);
            return new BroadcastOperatorImpl((BroadcastOperatorSpec)operatorSpec, systemStream, context);
        }
        throw new IllegalArgumentException(String.format("Unsupported OperatorSpec: %s", operatorSpec.getClass().getName()));
    }

    private PartialJoinOperatorImpl getOrCreatePartialJoinOpImpls(JoinOperatorSpec joinOpSpec, boolean isLeft, Clock clock) {
        KV partialJoinOpImpls = this.joinOpImpls.computeIfAbsent(joinOpSpec.getOpId(), joinOpId -> {
            PartialJoinFunction<Object, Object, Object, Object> leftJoinFn = this.createLeftJoinFn(joinOpSpec);
            PartialJoinFunction<Object, Object, Object, Object> rightJoinFn = this.createRightJoinFn(joinOpSpec);
            return new KV(new PartialJoinOperatorImpl<Object, Object, Object, Object>(joinOpSpec, true, leftJoinFn, rightJoinFn, clock), new PartialJoinOperatorImpl<Object, Object, Object, Object>(joinOpSpec, false, rightJoinFn, leftJoinFn, clock));
        });
        if (isLeft) {
            return (PartialJoinOperatorImpl)partialJoinOpImpls.getKey();
        }
        return (PartialJoinOperatorImpl)partialJoinOpImpls.getValue();
    }

    private PartialJoinFunction<Object, Object, Object, Object> createLeftJoinFn(final JoinOperatorSpec joinOpSpec) {
        return new PartialJoinFunction<Object, Object, Object, Object>(){
            private final JoinFunction joinFn;
            private KeyValueStore<Object, TimestampedValue<Object>> leftStreamState;
            {
                this.joinFn = joinOpSpec.getJoinFn();
            }

            @Override
            public Object apply(Object m, Object om) {
                return this.joinFn.apply(m, om);
            }

            @Override
            public Object getKey(Object message) {
                return this.joinFn.getFirstKey(message);
            }

            @Override
            public KeyValueStore<Object, TimestampedValue<Object>> getState() {
                return this.leftStreamState;
            }

            public void init(Context context) {
                String leftStoreName = joinOpSpec.getLeftOpId();
                this.leftStreamState = context.getTaskContext().getStore(leftStoreName);
                this.joinFn.init(context);
            }

            public void close() {
                this.joinFn.close();
            }
        };
    }

    private PartialJoinFunction<Object, Object, Object, Object> createRightJoinFn(final JoinOperatorSpec joinOpSpec) {
        return new PartialJoinFunction<Object, Object, Object, Object>(){
            private final JoinFunction joinFn;
            private KeyValueStore<Object, TimestampedValue<Object>> rightStreamState;
            {
                this.joinFn = joinOpSpec.getJoinFn();
            }

            @Override
            public Object apply(Object m, Object om) {
                return this.joinFn.apply(om, m);
            }

            @Override
            public Object getKey(Object message) {
                return this.joinFn.getSecondKey(message);
            }

            public void init(Context context) {
                String rightStoreName = joinOpSpec.getRightOpId();
                this.rightStreamState = context.getTaskContext().getStore(rightStoreName);
            }

            @Override
            public KeyValueStore<Object, TimestampedValue<Object>> getState() {
                return this.rightStreamState;
            }
        };
    }

    static Map<SystemStream, Integer> getProducerTaskCountForIntermediateStreams(Multimap<SystemStream, String> streamToConsumerTasks, Multimap<SystemStream, SystemStream> intermediateToInputStreams) {
        HashMap<SystemStream, Integer> result = new HashMap<SystemStream, Integer>();
        intermediateToInputStreams.asMap().entrySet().forEach(entry -> result.put((SystemStream)entry.getKey(), ((Collection)entry.getValue()).stream().flatMap(systemStream -> streamToConsumerTasks.get(systemStream).stream()).collect(Collectors.toSet()).size()));
        return result;
    }

    static Multimap<SystemStream, String> getStreamToConsumerTasks(JobModel jobModel) {
        HashMultimap streamToConsumerTasks = HashMultimap.create();
        jobModel.getContainers().values().forEach(arg_0 -> OperatorImplGraph.lambda$getStreamToConsumerTasks$9((Multimap)streamToConsumerTasks, arg_0));
        return streamToConsumerTasks;
    }

    static Multimap<SystemStream, SystemStream> getIntermediateToInputStreamsMap(OperatorSpecGraph specGraph, StreamConfig streamConfig) {
        HashMultimap outputToInputStreams = HashMultimap.create();
        specGraph.getInputOperators().entrySet().stream().forEach(arg_0 -> OperatorImplGraph.lambda$getIntermediateToInputStreamsMap$10(streamConfig, (Multimap)outputToInputStreams, arg_0));
        return outputToInputStreams;
    }

    private static void computeOutputToInput(SystemStream input, OperatorSpec opSpec, Multimap<SystemStream, SystemStream> outputToInputStreams, StreamConfig streamConfig) {
        if (opSpec instanceof PartitionByOperatorSpec) {
            PartitionByOperatorSpec spec2 = (PartitionByOperatorSpec)opSpec;
            SystemStream systemStream = streamConfig.streamIdToSystemStream(spec2.getOutputStream().getStreamId());
            outputToInputStreams.put((Object)systemStream, (Object)input);
        } else if (opSpec instanceof BroadcastOperatorSpec) {
            BroadcastOperatorSpec spec3 = (BroadcastOperatorSpec)opSpec;
            SystemStream systemStream = streamConfig.streamIdToSystemStream(spec3.getOutputStream().getStreamId());
            outputToInputStreams.put((Object)systemStream, (Object)input);
        } else {
            Collection nextOperators = opSpec.getRegisteredOperatorSpecs();
            nextOperators.forEach(spec -> OperatorImplGraph.computeOutputToInput(input, spec, outputToInputStreams, streamConfig));
        }
    }

    private boolean hasIntermediateStreams(OperatorSpecGraph specGraph) {
        return !Collections.disjoint(specGraph.getInputOperators().keySet(), specGraph.getOutputStreams().keySet());
    }

    private static /* synthetic */ void lambda$getIntermediateToInputStreamsMap$10(StreamConfig streamConfig, Multimap outputToInputStreams, Map.Entry entry) {
        SystemStream systemStream = streamConfig.streamIdToSystemStream((String)entry.getKey());
        OperatorImplGraph.computeOutputToInput(systemStream, (OperatorSpec)entry.getValue(), (Multimap<SystemStream, SystemStream>)outputToInputStreams, streamConfig);
    }

    private static /* synthetic */ void lambda$getStreamToConsumerTasks$9(Multimap streamToConsumerTasks, ContainerModel containerModel) {
        containerModel.getTasks().values().forEach(taskModel -> taskModel.getSystemStreamPartitions().forEach(ssp -> streamToConsumerTasks.put((Object)ssp.getSystemStream(), (Object)taskModel.getTaskName().getTaskName())));
    }
}

