/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MetricsConfig;
import org.apache.samza.container.TaskName;
import org.apache.samza.context.Context;
import org.apache.samza.context.TaskContextImpl;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.Timer;
import org.apache.samza.operators.Scheduler;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.apache.samza.operators.impl.ControlMessageSender;
import org.apache.samza.operators.impl.EndOfStreamStates;
import org.apache.samza.operators.impl.WatermarkStates;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.scheduler.CallbackScheduler;
import org.apache.samza.system.ControlMessage;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.WatermarkMessage;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;
import org.apache.samza.util.HighResolutionClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperatorImpl<M, RM> {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorImpl.class);
    private static final String METRICS_GROUP = OperatorImpl.class.getName();
    private boolean initialized;
    private boolean closed;
    private HighResolutionClock highResClock;
    private Counter numMessage;
    private Timer handleMessageNs;
    private Timer handleTimerNs;
    private long currentWatermark = -1L;
    private long outputWatermark = -1L;
    private TaskName taskName;
    private boolean usedInCurrentTask = false;
    Set<OperatorImpl<RM, ?>> registeredOperators;
    Set<OperatorImpl<?, M>> prevOperators;
    Set<SystemStream> inputStreams;
    private TaskModel taskModel;
    private EndOfStreamStates eosStates;
    private WatermarkStates watermarkStates;
    private CallbackScheduler callbackScheduler;
    private ControlMessageSender controlMessageSender;

    public final void init(Context context) {
        String opId = this.getOpImplId();
        if (this.initialized) {
            throw new IllegalStateException(String.format("Attempted to initialize Operator %s more than once.", opId));
        }
        if (this.closed) {
            throw new IllegalStateException(String.format("Attempted to initialize Operator %s after it was closed.", opId));
        }
        this.highResClock = this.createHighResClock(context.getJobContext().getConfig());
        this.registeredOperators = new HashSet();
        this.prevOperators = new HashSet();
        this.inputStreams = new HashSet<SystemStream>();
        TaskContextImpl taskContext = (TaskContextImpl)context.getTaskContext();
        MetricsRegistry metricsRegistry = taskContext.getTaskMetricsRegistry();
        this.numMessage = metricsRegistry.newCounter(METRICS_GROUP, opId + "-messages");
        this.handleMessageNs = metricsRegistry.newTimer(METRICS_GROUP, opId + "-handle-message-ns");
        this.handleTimerNs = metricsRegistry.newTimer(METRICS_GROUP, opId + "-handle-timer-ns");
        this.taskName = taskContext.getTaskModel().getTaskName();
        this.eosStates = (EndOfStreamStates)taskContext.fetchObject(EndOfStreamStates.class.getName());
        this.watermarkStates = (WatermarkStates)taskContext.fetchObject(WatermarkStates.class.getName());
        this.controlMessageSender = new ControlMessageSender(taskContext.getStreamMetadataCache());
        this.taskModel = taskContext.getTaskModel();
        this.callbackScheduler = taskContext.getCallbackScheduler();
        this.handleInit(context);
        this.initialized = true;
    }

    protected abstract void handleInit(Context var1);

    void registerNextOperator(OperatorImpl<RM, ?> nextOperator) {
        if (!this.initialized) {
            throw new IllegalStateException(String.format("Attempted to register next operator before initializing operator %s.", this.getOpImplId()));
        }
        this.registeredOperators.add(nextOperator);
        nextOperator.registerPrevOperator(this);
    }

    void registerPrevOperator(OperatorImpl<?, M> prevOperator) {
        this.prevOperators.add(prevOperator);
    }

    void registerInputStream(SystemStream input) {
        this.inputStreams.add(input);
        this.usedInCurrentTask = this.usedInCurrentTask || this.taskModel.getSystemStreamPartitions().stream().anyMatch(ssp -> ssp.getSystemStream().equals((Object)input));
    }

    public final void onMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        Collection<RM> results;
        this.numMessage.inc();
        long startNs = this.highResClock.nanoTime();
        try {
            results = this.handleMessage(message, collector, coordinator);
        }
        catch (ClassCastException e) {
            String actualType = e.getMessage().replaceFirst(" cannot be cast to .*", "");
            String expectedType = e.getMessage().replaceFirst(".* cannot be cast to ", "");
            throw new SamzaException(String.format("Error applying operator %s (created at %s) to its input message. Expected input message to be of type %s, but found it to be of type %s. Are Serdes for the inputs to this operator configured correctly?", this.getOpImplId(), this.getOperatorSpec().getSourceLocation(), expectedType, actualType), (Throwable)e);
        }
        long endNs = this.highResClock.nanoTime();
        this.handleMessageNs.update(endNs - startNs);
        results.forEach(rm2 -> this.registeredOperators.forEach(op -> op.onMessage(rm2, collector, coordinator)));
        WatermarkFunction watermarkFn = this.getOperatorSpec().getWatermarkFn();
        if (watermarkFn != null) {
            Long outputWm = watermarkFn.getOutputWatermark();
            this.propagateWatermark(outputWm, collector, coordinator);
        }
    }

    protected abstract Collection<RM> handleMessage(M var1, MessageCollector var2, TaskCoordinator var3);

    public final void onTimer(MessageCollector collector, TaskCoordinator coordinator) {
        long startNs = this.highResClock.nanoTime();
        Collection<RM> results = this.handleTimer(collector, coordinator);
        long endNs = this.highResClock.nanoTime();
        this.handleTimerNs.update(endNs - startNs);
        results.forEach(rm2 -> this.registeredOperators.forEach(op -> op.onMessage(rm2, collector, coordinator)));
        this.registeredOperators.forEach(op -> op.onTimer(collector, coordinator));
    }

    protected Collection<RM> handleTimer(MessageCollector collector, TaskCoordinator coordinator) {
        return Collections.emptyList();
    }

    public final void aggregateEndOfStream(EndOfStreamMessage eos, SystemStreamPartition ssp, MessageCollector collector, TaskCoordinator coordinator) {
        LOG.info("Received end-of-stream message from task {} in {}", (Object)eos.getTaskName(), (Object)ssp);
        this.eosStates.update(eos, ssp);
        SystemStream stream = ssp.getSystemStream();
        if (this.eosStates.isEndOfStream(stream)) {
            LOG.info("Input {} reaches the end for task {}", (Object)stream.toString(), (Object)this.taskName.getTaskName());
            if (eos.getTaskName() != null) {
                this.controlMessageSender.broadcastToOtherPartitions((ControlMessage)new EndOfStreamMessage(), ssp, collector);
            }
            this.onEndOfStream(collector, coordinator);
            if (this.eosStates.allEndOfStream()) {
                LOG.info("All input streams have reached the end for task {}", (Object)this.taskName.getTaskName());
                coordinator.commit(TaskCoordinator.RequestScope.CURRENT_TASK);
                coordinator.shutdown(TaskCoordinator.RequestScope.CURRENT_TASK);
            }
        }
    }

    private final void onEndOfStream(MessageCollector collector, TaskCoordinator coordinator) {
        if (this.inputStreams.stream().allMatch(input -> this.eosStates.isEndOfStream((SystemStream)input))) {
            Collection<RM> results = this.handleEndOfStream(collector, coordinator);
            results.forEach(rm2 -> this.registeredOperators.forEach(op -> op.onMessage(rm2, collector, coordinator)));
            this.registeredOperators.forEach(op -> op.onEndOfStream(collector, coordinator));
        }
    }

    protected Collection<RM> handleEndOfStream(MessageCollector collector, TaskCoordinator coordinator) {
        return Collections.emptyList();
    }

    public final void aggregateWatermark(WatermarkMessage watermarkMessage, SystemStreamPartition ssp, MessageCollector collector, TaskCoordinator coordinator) {
        LOG.debug("Received watermark {} from {}", (Object)watermarkMessage.getTimestamp(), (Object)ssp);
        this.watermarkStates.update(watermarkMessage, ssp);
        long watermark = this.watermarkStates.getWatermark(ssp.getSystemStream());
        if (this.currentWatermark < watermark) {
            LOG.debug("Got watermark {} from stream {}", (Object)watermark, (Object)ssp.getSystemStream());
            if (watermarkMessage.getTaskName() != null) {
                this.controlMessageSender.broadcastToOtherPartitions((ControlMessage)new WatermarkMessage(watermark), ssp, collector);
            }
            this.onWatermark(watermark, collector, coordinator);
            this.watermarkStates.updateAggregateMetric(ssp, watermark);
        }
    }

    private final void onWatermark(long watermark, MessageCollector collector, TaskCoordinator coordinator) {
        long inputWatermarkMin = this.prevOperators.isEmpty() ? watermark : this.prevOperators.stream().map(op -> op.getOutputWatermark()).min(Long::compare).get();
        if (this.currentWatermark < inputWatermarkMin) {
            Long outputWm;
            Collection<RM> output;
            this.currentWatermark = inputWatermarkMin;
            LOG.trace("Advance input watermark to {} in operator {}", (Object)this.currentWatermark, (Object)this.getOpImplId());
            WatermarkFunction watermarkFn = this.getOperatorSpec().getWatermarkFn();
            if (watermarkFn != null) {
                output = watermarkFn.processWatermark(this.currentWatermark);
                outputWm = watermarkFn.getOutputWatermark();
            } else {
                output = this.handleWatermark(this.currentWatermark, collector, coordinator);
                outputWm = this.currentWatermark;
            }
            if (!output.isEmpty()) {
                output.forEach(rm2 -> this.registeredOperators.forEach(op -> op.onMessage(rm2, collector, coordinator)));
            }
            this.propagateWatermark(outputWm, collector, coordinator);
        }
    }

    private void propagateWatermark(Long outputWm, MessageCollector collector, TaskCoordinator coordinator) {
        if (outputWm != null) {
            if (this.outputWatermark < outputWm) {
                this.outputWatermark = outputWm;
                LOG.debug("Advance output watermark to {} in operator {}", (Object)this.outputWatermark, (Object)this.getOpImplId());
                this.registeredOperators.forEach(op -> op.onWatermark(this.outputWatermark, collector, coordinator));
            } else if (this.outputWatermark > outputWm) {
                LOG.warn("Ignore watermark {} that is smaller than the previous watermark {}.", (Object)outputWm, (Object)this.outputWatermark);
            }
        }
    }

    protected Collection<RM> handleWatermark(long inputWatermark, MessageCollector collector, TaskCoordinator coordinator) {
        return Collections.emptyList();
    }

    final long getInputWatermark() {
        return this.currentWatermark;
    }

    final long getOutputWatermark() {
        if (this.usedInCurrentTask) {
            return this.outputWatermark;
        }
        return Long.MAX_VALUE;
    }

    <K> Scheduler<K> createOperatorScheduler() {
        return new Scheduler<K>(){

            public void schedule(K key, long time) {
                OperatorImpl.this.callbackScheduler.scheduleCallback(key, time, (k, collector, coordinator) -> {
                    ScheduledFunction scheduledFn = OperatorImpl.this.getOperatorSpec().getScheduledFn();
                    if (scheduledFn != null) {
                        Collection output = scheduledFn.onCallback(key, time);
                        if (!output.isEmpty()) {
                            output.forEach(rm2 -> OperatorImpl.this.registeredOperators.forEach(op -> op.onMessage(rm2, collector, coordinator)));
                        }
                    } else {
                        throw new SamzaException(String.format("Operator %s id %s (created at %s) must implement ScheduledFunction to use system timer.", OperatorImpl.this.getOperatorSpec().getOpCode().name(), OperatorImpl.this.getOpImplId(), OperatorImpl.this.getOperatorSpec().getSourceLocation()));
                    }
                });
            }

            public void delete(K key) {
                OperatorImpl.this.callbackScheduler.deleteCallback(key);
            }
        };
    }

    public void close() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Attempted to close Operator %s more than once.", this.getOpImplId()));
        }
        this.handleClose();
        this.closed = true;
    }

    protected abstract void handleClose();

    protected abstract OperatorSpec<M, RM> getOperatorSpec();

    protected String getOpImplId() {
        return this.getOperatorSpec().getOpId();
    }

    private HighResolutionClock createHighResClock(Config config) {
        if (new MetricsConfig(config).getMetricsTimerEnabled()) {
            return System::nanoTime;
        }
        return () -> 0L;
    }
}

