/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;

class EndOfStreamStates {
    private final Map<SystemStreamPartition, EndOfStreamState> eosStates;

    EndOfStreamStates(Set<SystemStreamPartition> ssps, Map<SystemStream, Integer> producerTaskCounts) {
        HashMap states = new HashMap();
        ssps.forEach(ssp -> states.put(ssp, new EndOfStreamState(producerTaskCounts.getOrDefault(ssp.getSystemStream(), 0))));
        this.eosStates = Collections.unmodifiableMap(states);
    }

    void update(EndOfStreamMessage eos, SystemStreamPartition ssp) {
        EndOfStreamState state = this.eosStates.get(ssp);
        state.update(eos.getTaskName());
    }

    boolean isEndOfStream(SystemStream systemStream) {
        return this.eosStates.entrySet().stream().filter(entry -> ((SystemStreamPartition)entry.getKey()).getSystemStream().equals((Object)systemStream)).allMatch(entry -> ((EndOfStreamState)entry.getValue()).isEndOfStream());
    }

    boolean allEndOfStream() {
        return this.eosStates.values().stream().allMatch(EndOfStreamState::isEndOfStream);
    }

    private static final class EndOfStreamState {
        private final Set<String> tasks = new HashSet<String>();
        private final int expectedTotal;
        private volatile boolean isEndOfStream = false;

        EndOfStreamState(int expectedTotal) {
            this.expectedTotal = expectedTotal;
        }

        synchronized void update(String taskName) {
            if (taskName != null) {
                this.tasks.add(taskName);
                this.isEndOfStream = this.tasks.size() == this.expectedTotal;
            } else {
                this.isEndOfStream = true;
            }
        }

        boolean isEndOfStream() {
            return this.isEndOfStream;
        }
    }
}

