/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.samza.SamzaException;
import org.apache.samza.system.ControlMessage;
import org.apache.samza.system.MessageType;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControlMessageSender {
    private static final Logger LOG = LoggerFactory.getLogger(ControlMessageSender.class);
    private static final Map<SystemStream, Integer> PARTITION_COUNT_CACHE = new ConcurrentHashMap<SystemStream, Integer>();
    private final StreamMetadataCache metadataCache;

    ControlMessageSender(StreamMetadataCache metadataCache) {
        this.metadataCache = metadataCache;
    }

    void send(ControlMessage message, SystemStream systemStream, MessageCollector collector) {
        int partitionCount = this.getPartitionCount(systemStream);
        int aggregatePartition = systemStream.getStream().hashCode() % partitionCount;
        LOG.debug(String.format("Send %s message from task %s to %s partition %s for aggregation", MessageType.of((Object)message).name(), message.getTaskName(), systemStream, aggregatePartition));
        OutgoingMessageEnvelope envelopeOut = new OutgoingMessageEnvelope(systemStream, (Object)aggregatePartition, null, (Object)message);
        collector.send(envelopeOut);
    }

    void broadcastToOtherPartitions(ControlMessage message, SystemStreamPartition ssp, MessageCollector collector) {
        SystemStream systemStream = ssp.getSystemStream();
        int partitionCount = this.getPartitionCount(systemStream);
        int currentPartition = ssp.getPartition().getPartitionId();
        for (int i = 0; i < partitionCount; ++i) {
            if (i == currentPartition) continue;
            OutgoingMessageEnvelope envelopeOut = new OutgoingMessageEnvelope(systemStream, (Object)i, null, (Object)message);
            collector.send(envelopeOut);
        }
    }

    private int getPartitionCount(SystemStream systemStream) {
        return PARTITION_COUNT_CACHE.computeIfAbsent(systemStream, ss -> {
            SystemStreamMetadata metadata = this.metadataCache.getSystemStreamMetadata((SystemStream)ss, true);
            if (metadata == null) {
                throw new SamzaException("Unable to find metadata for stream " + systemStream);
            }
            return metadata.getSystemStreamPartitionMetadata().size();
        });
    }
}

