/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.samza.context.Context;
import org.apache.samza.operators.impl.OperatorImpl;
import org.apache.samza.operators.spec.BroadcastOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.system.ControlMessage;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.WatermarkMessage;
import org.apache.samza.task.MessageCollector;
import org.apache.samza.task.TaskCoordinator;

class BroadcastOperatorImpl<M>
extends OperatorImpl<M, Void> {
    private final BroadcastOperatorSpec<M> broadcastOpSpec;
    private final SystemStream systemStream;
    private final String taskName;

    BroadcastOperatorImpl(BroadcastOperatorSpec<M> broadcastOpSpec, SystemStream systemStream, Context context) {
        this.broadcastOpSpec = broadcastOpSpec;
        this.systemStream = systemStream;
        this.taskName = context.getTaskContext().getTaskModel().getTaskName().getTaskName();
    }

    @Override
    protected void handleInit(Context context) {
    }

    @Override
    protected Collection<Void> handleMessage(M message, MessageCollector collector, TaskCoordinator coordinator) {
        collector.send(new OutgoingMessageEnvelope(this.systemStream, (Object)0, null, message));
        return Collections.emptyList();
    }

    @Override
    protected void handleClose() {
    }

    @Override
    protected OperatorSpec<M, Void> getOperatorSpec() {
        return this.broadcastOpSpec;
    }

    @Override
    protected Collection<Void> handleEndOfStream(MessageCollector collector, TaskCoordinator coordinator) {
        this.sendControlMessage((ControlMessage)new EndOfStreamMessage(this.taskName), collector);
        return Collections.emptyList();
    }

    @Override
    protected Collection<Void> handleWatermark(long watermark, MessageCollector collector, TaskCoordinator coordinator) {
        this.sendControlMessage((ControlMessage)new WatermarkMessage(watermark, this.taskName), collector);
        return Collections.emptyList();
    }

    private void sendControlMessage(ControlMessage message, MessageCollector collector) {
        OutgoingMessageEnvelope envelopeOut = new OutgoingMessageEnvelope(this.systemStream, (Object)0, null, (Object)message);
        collector.send(envelopeOut);
    }
}

