/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.application.descriptors.StreamApplicationDescriptorImpl;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.serializers.SerializableSerde;

public class OperatorSpecGraph
implements Serializable {
    private final Map<String, InputOperatorSpec> inputOperators;
    private final Map<String, OutputStreamImpl> outputStreams;
    private final Set<String> intermediateBroadcastStreamIds;
    private final Set<OperatorSpec> allOpSpecs;
    private final boolean hasWindowOrJoins;
    private final transient SerializableSerde<OperatorSpecGraph> opSpecGraphSerde = new SerializableSerde();
    private final transient byte[] serializedOpSpecGraph;

    public OperatorSpecGraph(StreamApplicationDescriptorImpl streamAppDesc) {
        this.inputOperators = streamAppDesc.getInputOperators();
        this.outputStreams = streamAppDesc.getOutputStreams();
        this.intermediateBroadcastStreamIds = streamAppDesc.getIntermediateBroadcastStreamIds();
        this.allOpSpecs = Collections.unmodifiableSet(this.findAllOperatorSpecs());
        this.hasWindowOrJoins = this.checkWindowOrJoins();
        this.serializedOpSpecGraph = this.opSpecGraphSerde.toBytes((Serializable)this);
    }

    public Map<String, InputOperatorSpec> getInputOperators() {
        return this.inputOperators;
    }

    public Map<String, OutputStreamImpl> getOutputStreams() {
        return this.outputStreams;
    }

    public Set<String> getIntermediateBroadcastStreamIds() {
        return this.intermediateBroadcastStreamIds;
    }

    public Collection<OperatorSpec> getAllOperatorSpecs() {
        return this.allOpSpecs;
    }

    public boolean hasWindowOrJoins() {
        return this.hasWindowOrJoins;
    }

    public OperatorSpecGraph clone() {
        if (this.opSpecGraphSerde == null) {
            throw new IllegalStateException("Cannot clone from an already deserialized OperatorSpecGraph.");
        }
        return (OperatorSpecGraph)this.opSpecGraphSerde.fromBytes(this.serializedOpSpecGraph);
    }

    private HashSet<OperatorSpec> findAllOperatorSpecs() {
        Collection<InputOperatorSpec> inputOperatorSpecs = this.inputOperators.values();
        HashSet<OperatorSpec> operatorSpecs = new HashSet<OperatorSpec>();
        for (InputOperatorSpec inputOperatorSpec : inputOperatorSpecs) {
            operatorSpecs.add(inputOperatorSpec);
            this.doGetOperatorSpecs(inputOperatorSpec, operatorSpecs);
        }
        return operatorSpecs;
    }

    private void doGetOperatorSpecs(OperatorSpec operatorSpec, Set<OperatorSpec> specs) {
        Collection registeredOperatorSpecs = operatorSpec.getRegisteredOperatorSpecs();
        for (OperatorSpec registeredOperatorSpec : registeredOperatorSpecs) {
            specs.add(registeredOperatorSpec);
            this.doGetOperatorSpecs(registeredOperatorSpec, specs);
        }
    }

    private boolean checkWindowOrJoins() {
        Set windowOrJoinSpecs = this.allOpSpecs.stream().filter(spec -> spec.getOpCode() == OperatorSpec.OpCode.WINDOW || spec.getOpCode() == OperatorSpec.OpCode.JOIN).collect(Collectors.toSet());
        return windowOrJoinSpecs.size() != 0;
    }
}

