/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Collection;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.StreamApplicationDescriptorImpl;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.TableImpl;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SinkFunction;
import org.apache.samza.operators.functions.StreamTableJoinFunction;
import org.apache.samza.operators.spec.BroadcastOperatorSpec;
import org.apache.samza.operators.spec.JoinOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OperatorSpecs;
import org.apache.samza.operators.spec.OutputOperatorSpec;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.operators.spec.PartitionByOperatorSpec;
import org.apache.samza.operators.spec.SendToTableOperatorSpec;
import org.apache.samza.operators.spec.SinkOperatorSpec;
import org.apache.samza.operators.spec.StreamOperatorSpec;
import org.apache.samza.operators.spec.StreamTableJoinOperatorSpec;
import org.apache.samza.operators.spec.WindowOperatorSpec;
import org.apache.samza.operators.stream.IntermediateMessageStreamImpl;
import org.apache.samza.operators.windows.Window;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.operators.windows.internal.WindowInternal;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.Table;
import org.apache.samza.table.TableSpec;

public class MessageStreamImpl<M>
implements MessageStream<M> {
    private final StreamApplicationDescriptorImpl streamAppDesc;
    private final OperatorSpec operatorSpec;

    public MessageStreamImpl(StreamApplicationDescriptorImpl streamAppDesc, OperatorSpec<?, M> operatorSpec) {
        this.streamAppDesc = streamAppDesc;
        this.operatorSpec = operatorSpec;
    }

    public <TM> MessageStream<TM> map(MapFunction<? super M, ? extends TM> mapFn) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.MAP);
        StreamOperatorSpec<? super M, ? extends TM> op = OperatorSpecs.createMapOperatorSpec(mapFn, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        return new MessageStreamImpl<TM>(this.streamAppDesc, op);
    }

    public MessageStream<M> filter(FilterFunction<? super M> filterFn) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.FILTER);
        StreamOperatorSpec<? super M, ? super M> op = OperatorSpecs.createFilterOperatorSpec(filterFn, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        return new MessageStreamImpl<M>(this.streamAppDesc, op);
    }

    public <TM> MessageStream<TM> flatMap(FlatMapFunction<? super M, ? extends TM> flatMapFn) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.FLAT_MAP);
        StreamOperatorSpec<? super M, ? extends TM> op = OperatorSpecs.createFlatMapOperatorSpec(flatMapFn, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        return new MessageStreamImpl<TM>(this.streamAppDesc, op);
    }

    public void sink(SinkFunction<? super M> sinkFn) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.SINK);
        SinkOperatorSpec<? super M> op = OperatorSpecs.createSinkOperatorSpec(sinkFn, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
    }

    public void sendTo(OutputStream<M> outputStream) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.SEND_TO);
        OutputOperatorSpec op = OperatorSpecs.createSendToOperatorSpec((OutputStreamImpl)outputStream, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
    }

    public <K, WV> MessageStream<WindowPane<K, WV>> window(Window<M, K, WV> window2, String userDefinedId) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.WINDOW, userDefinedId);
        WindowOperatorSpec op = OperatorSpecs.createWindowOperatorSpec((WindowInternal)window2, opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        return new MessageStreamImpl<WindowPane<K, WV>>(this.streamAppDesc, op);
    }

    public <K, OM, JM> MessageStream<JM> join(MessageStream<OM> otherStream, JoinFunction<? extends K, ? super M, ? super OM, ? extends JM> joinFn, Serde<K> keySerde, Serde<M> messageSerde, Serde<OM> otherMessageSerde, Duration ttl, String userDefinedId) {
        if (otherStream.equals((Object)this)) {
            throw new SamzaException("Cannot join a MessageStream with itself.");
        }
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.JOIN, userDefinedId);
        OperatorSpec<?, M> otherOpSpec = ((MessageStreamImpl)otherStream).getOperatorSpec();
        JoinOperatorSpec<? extends K, ? super M, ? super OM, ? extends JM> op = OperatorSpecs.createJoinOperatorSpec(this.operatorSpec, otherOpSpec, joinFn, keySerde, messageSerde, otherMessageSerde, ttl.toMillis(), opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        otherOpSpec.registerNextOperatorSpec(op);
        return new MessageStreamImpl<M>(this.streamAppDesc, op);
    }

    public <K, R extends KV, JM> MessageStream<JM> join(Table<R> table, StreamTableJoinFunction<? extends K, ? super M, ? super R, ? extends JM> joinFn) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.JOIN);
        TableSpec tableSpec = ((TableImpl)table).getTableSpec();
        StreamTableJoinOperatorSpec<? extends K, ? super M, ? super R, ? extends JM> joinOpSpec = OperatorSpecs.createStreamTableJoinOperatorSpec(tableSpec, joinFn, opId);
        this.operatorSpec.registerNextOperatorSpec(joinOpSpec);
        return new MessageStreamImpl<M>(this.streamAppDesc, joinOpSpec);
    }

    public MessageStream<M> merge(Collection<? extends MessageStream<? extends M>> otherStreams) {
        if (otherStreams.isEmpty()) {
            return this;
        }
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.MERGE);
        StreamOperatorSpec op = OperatorSpecs.createMergeOperatorSpec(opId);
        this.operatorSpec.registerNextOperatorSpec(op);
        otherStreams.forEach(other -> ((MessageStreamImpl)other).getOperatorSpec().registerNextOperatorSpec(op));
        return new MessageStreamImpl(this.streamAppDesc, op);
    }

    public <K, V> MessageStream<KV<K, V>> partitionBy(MapFunction<? super M, ? extends K> keyExtractor, MapFunction<? super M, ? extends V> valueExtractor, KVSerde<K, V> serde, String userDefinedId) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.PARTITION_BY, userDefinedId);
        IntermediateMessageStreamImpl<KV<K, V>> intermediateStream = this.streamAppDesc.getIntermediateStream(opId, serde, false);
        if (!intermediateStream.isKeyed()) {
            throw new SamzaException("partitionBy can not be used with a default serde that is not a KVSerde.");
        }
        PartitionByOperatorSpec<? super M, ? extends K, ? extends V> partitionByOperatorSpec = OperatorSpecs.createPartitionByOperatorSpec(intermediateStream.getOutputStream(), keyExtractor, valueExtractor, opId);
        this.operatorSpec.registerNextOperatorSpec(partitionByOperatorSpec);
        return intermediateStream;
    }

    public <K, V> void sendTo(Table<KV<K, V>> table) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.SEND_TO);
        SendToTableOperatorSpec op = OperatorSpecs.createSendToTableOperatorSpec(((TableImpl)table).getTableSpec(), opId);
        this.operatorSpec.registerNextOperatorSpec(op);
    }

    public MessageStream<M> broadcast(Serde<M> serde, String userDefinedId) {
        String opId = this.streamAppDesc.getNextOpId(OperatorSpec.OpCode.BROADCAST, userDefinedId);
        IntermediateMessageStreamImpl<M> intermediateStream = this.streamAppDesc.getIntermediateStream(opId, serde, true);
        BroadcastOperatorSpec<M> broadcastOperatorSpec = OperatorSpecs.createBroadCastOperatorSpec(intermediateStream.getOutputStream(), opId);
        this.operatorSpec.registerNextOperatorSpec(broadcastOperatorSpec);
        return intermediateStream;
    }

    @VisibleForTesting
    public OperatorSpec<?, M> getOperatorSpec() {
        return this.operatorSpec;
    }
}

