/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics.reporter;

import org.apache.samza.SamzaException;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MetricsConfig$;
import org.apache.samza.config.SerializerConfig$;
import org.apache.samza.config.StreamConfig$;
import org.apache.samza.config.SystemConfig$;
import org.apache.samza.config.TaskConfig$;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.metrics.MetricsReporterFactory;
import org.apache.samza.metrics.reporter.MetricsSnapshot;
import org.apache.samza.metrics.reporter.MetricsSnapshotReporter;
import org.apache.samza.metrics.reporter.MetricsSnapshotReporter$;
import org.apache.samza.serializers.MetricsSnapshotSerdeV2;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeFactory;
import org.apache.samza.serializers.Serializer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.apache.samza.util.StreamUtil;
import org.apache.samza.util.Util$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u001b\tqR*\u001a;sS\u000e\u001c8K\\1qg\"|GOU3q_J$XM\u001d$bGR|'/\u001f\u0006\u0003\u0007\u0011\t\u0001B]3q_J$XM\u001d\u0006\u0003\u000b\u0019\tq!\\3ue&\u001c7O\u0003\u0002\b\u0011\u0005)1/Y7{C*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\t1R*\u001a;sS\u000e\u001c(+\u001a9peR,'OR1di>\u0014\u0018\u0010\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\r\u0005!Q\u000f^5m\u0013\tyBDA\u0004M_\u001e<\u0017N\\4\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\u0014\u0001\t\u00039\u0013AE4fi6+GO]5dgJ+\u0007o\u001c:uKJ$B\u0001K\u00168sA\u0011q#K\u0005\u0003U\u0011\u0011q\"T3ue&\u001c7OU3q_J$XM\u001d\u0005\u0006Y\u0015\u0002\r!L\u0001\u0005]\u0006lW\r\u0005\u0002/i9\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0004\u0007C\u00039K\u0001\u0007Q&A\u0007d_:$\u0018-\u001b8fe:\u000bW.\u001a\u0005\u0006u\u0015\u0002\raO\u0001\u0007G>tg-[4\u0011\u0005qrT\"A\u001f\u000b\u0005i2\u0011BA >\u0005\u0019\u0019uN\u001c4jO\u0002")
public class MetricsSnapshotReporterFactory
implements MetricsReporterFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetricsSnapshotReporterFactory metricsSnapshotReporterFactory = this;
        synchronized (metricsSnapshotReporterFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        MetricsSnapshotReporterFactory metricsSnapshotReporterFactory = this;
        synchronized (metricsSnapshotReporterFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public MetricsReporter getMetricsReporter(String name, String containerName, Config config) {
        MetricsSnapshotSerdeV2 metricsSnapshotSerdeV2;
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating new metrics snapshot reporter.";
            }
        });
        String jobName = (String)JobConfig$.MODULE$.Config2Job(config).getName().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SamzaException("Job name must be defined in config.");
            }
        });
        String jobId = JobConfig$.MODULE$.Config2Job(config).getJobId();
        String taskClass = (String)TaskConfig$.MODULE$.Config2Task(config).getTaskClass().orElse((Function0)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)new ApplicationConfig(this.config$1).getAppClass());
            }
            {
                this.config$1 = config$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SamzaException("No task or app class defined for config.");
            }
        });
        String version = (String)Option$.MODULE$.apply((Object)Class.forName(taskClass).getPackage().getImplementationVersion()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsSnapshotReporterFactory $outer;

            public final String apply() {
                this.$outer.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Unable to find implementation version in jar's meta info. Defaulting to 0.0.1.";
                    }
                });
                return "0.0.1";
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String samzaVersion = (String)Option$.MODULE$.apply((Object)MetricsSnapshotReporterFactory.class.getPackage().getImplementationVersion()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsSnapshotReporterFactory $outer;

            public final String apply() {
                this.$outer.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Unable to find implementation samza version in jar's meta info. Defaulting to 0.0.1.";
                    }
                });
                return "0.0.1";
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String metricsSystemStreamName = (String)MetricsConfig$.MODULE$.Config2Metrics(config).getMetricsSnapshotReporterStream(name).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SamzaException("No metrics stream defined in config.");
            }
        });
        SystemStream systemStream = StreamUtil.getSystemStreamFromNames(metricsSystemStreamName);
        this.info((Function0<Object>)new Serializable(this, systemStream){
            public static final long serialVersionUID = 0L;
            private final SystemStream systemStream$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system stream %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStream$1}));
            }
            {
                this.systemStream$1 = systemStream$1;
            }
        });
        String systemName = systemStream.getSystem();
        String systemFactoryClassName = (String)SystemConfig$.MODULE$.Config2System(config).getSystemFactory(systemName).getOrElse((Function0)new Serializable(this, systemName){
            public static final long serialVersionUID = 0L;
            private final String systemName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Trying to fetch system factory for system %s, which isn't defined in config.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$1})));
            }
            {
                this.systemName$1 = systemName$1;
            }
        });
        SystemFactory systemFactory = Util$.MODULE$.getObj(systemFactoryClassName, SystemFactory.class);
        this.info((Function0<Object>)new Serializable(this, systemFactory){
            public static final long serialVersionUID = 0L;
            private final SystemFactory systemFactory$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got system factory %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemFactory$1}));
            }
            {
                this.systemFactory$1 = systemFactory$1;
            }
        });
        MetricsRegistryMap registry = new MetricsRegistryMap();
        SystemProducer producer = systemFactory.getProducer(systemName, config, (MetricsRegistry)registry);
        this.info((Function0<Object>)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final SystemProducer producer$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got producer %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producer$1}));
            }
            {
                this.producer$1 = producer$1;
            }
        });
        Option<String> streamSerdeName = StreamConfig$.MODULE$.Config2Stream(config).getStreamMsgSerde(systemStream);
        Option<String> systemSerdeName = SystemConfig$.MODULE$.Config2System(config).getSystemMsgSerde(systemName);
        String serdeName = (String)streamSerdeName.getOrElse((Function0)new Serializable(this, systemSerdeName){
            public static final long serialVersionUID = 0L;
            private final Option systemSerdeName$1;

            public final String apply() {
                return (String)this.systemSerdeName$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.systemSerdeName$1 = systemSerdeName$1;
            }
        });
        if (serdeName == null) {
            metricsSnapshotSerdeV2 = new MetricsSnapshotSerdeV2();
        } else {
            Serde serde;
            Option<String> option = SerializerConfig$.MODULE$.Config2Serializer(config).getSerdeClass(serdeName);
            if (option instanceof Some) {
                Some some = (Some)option;
                String serdeClassName = (String)some.x();
                serde = Util$.MODULE$.getObj(serdeClassName, SerdeFactory.class).getSerde(serdeName, config);
            } else {
                serde = null;
            }
            metricsSnapshotSerdeV2 = serde;
        }
        MetricsSnapshotSerdeV2 serde = metricsSnapshotSerdeV2;
        this.info((Function0<Object>)new Serializable(this, serde){
            public static final long serialVersionUID = 0L;
            private final Serde serde$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got serde %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serde$1}));
            }
            {
                this.serde$1 = serde$1;
            }
        });
        int pollingInterval = new StringOps(Predef$.MODULE$.augmentString((String)MetricsConfig$.MODULE$.Config2Metrics(config).getMetricsSnapshotReporterInterval(name).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "60";
            }
        }))).toInt();
        this.info((Function0<Object>)new Serializable(this, pollingInterval){
            public static final long serialVersionUID = 0L;
            private final int pollingInterval$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting polling interval to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pollingInterval$1)}));
            }
            {
                this.pollingInterval$1 = pollingInterval$1;
            }
        });
        Option<String> blacklist = MetricsConfig$.MODULE$.Config2Metrics(config).getMetricsSnapshotReporterBlacklist(name);
        this.info((Function0<Object>)new Serializable(this, blacklist){
            public static final long serialVersionUID = 0L;
            private final Option blacklist$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting blacklist to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blacklist$1}));
            }
            {
                this.blacklist$1 = blacklist$1;
            }
        });
        MetricsSnapshotReporter reporter = new MetricsSnapshotReporter(producer, systemStream, pollingInterval, jobName, jobId, containerName, version, samzaVersion, Util$.MODULE$.getLocalHost().getHostName(), (Serializer<MetricsSnapshot>)serde, blacklist, MetricsSnapshotReporter$.MODULE$.$lessinit$greater$default$12());
        reporter.register(this.getClass().getSimpleName().toString(), registry);
        return reporter;
    }

    public MetricsSnapshotReporterFactory() {
        Logging$class.$init$(this);
    }
}

