/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.MetricGroup;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.Timer;

public abstract class MetricsBase {
    protected final MetricGroup group;

    public MetricsBase(String prefix, MetricsRegistry registry) {
        String groupName = this.getClass().getName();
        this.group = new MetricGroup(groupName, prefix, registry);
    }

    public MetricsBase(MetricsRegistry registry) {
        this("", registry);
    }

    public Counter newCounter(String name) {
        return this.group.newCounter(name);
    }

    public <T> Gauge<T> newGauge(String name, T value) {
        return this.group.newGauge(name, value);
    }

    public <T> Gauge<T> newGauge(String name, MetricGroup.ValueFunction<T> valueFunc) {
        return this.group.newGauge(name, valueFunc);
    }

    public Timer newTimer(String name) {
        return this.group.newTimer(name);
    }
}

