/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.ListGauge;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.Timer;

public class MetricGroup {
    protected final MetricsRegistry registry;
    protected final String groupName;
    protected final String prefix;

    public MetricGroup(String groupName, String prefix, MetricsRegistry registry) {
        this.groupName = groupName;
        this.registry = registry;
        this.prefix = prefix;
    }

    public Counter newCounter(String name) {
        return this.registry.newCounter(this.groupName, (this.prefix + name).toLowerCase());
    }

    public <T> ListGauge<T> newListGauge(String name) {
        return this.registry.newListGauge(this.groupName, new ListGauge(name));
    }

    public <T> Gauge<T> newGauge(String name, T value) {
        return this.registry.newGauge(this.groupName, new Gauge((this.prefix + name).toLowerCase(), value));
    }

    public <T> Gauge<T> newGauge(String name, final ValueFunction<T> valueFunc) {
        return this.registry.newGauge(this.groupName, new Gauge<T>((this.prefix + name).toLowerCase(), valueFunc.getValue()){

            public T getValue() {
                return valueFunc.getValue();
            }
        });
    }

    public Timer newTimer(String name) {
        return this.registry.newTimer(this.groupName, (this.prefix + name).toLowerCase());
    }

    public static interface ValueFunction<T> {
        public T getValue();
    }
}

