/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.ListGauge;
import org.apache.samza.metrics.MetricGroup;
import org.apache.samza.metrics.MetricsHelper;
import org.apache.samza.metrics.MetricsHelper$class;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.Timer;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001-\u0011!B\u0013<n\u001b\u0016$(/[2t\u0015\t\u0019A!A\u0004nKR\u0014\u0018nY:\u000b\u0005\u00151\u0011!B:b[j\f'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u0019I1b\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011Q\"T3ue&\u001c7\u000fS3ma\u0016\u0014\bCA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\t%Vtg.\u00192mKB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u0005kRLG.\u0003\u0002$A\t9Aj\\4hS:<\u0007\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0011I,w-[:uef,\u0012a\n\t\u0003'!J!!\u000b\u0002\u0003\u001f5+GO]5dgJ+w-[:uefD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaJ\u0001\ne\u0016<\u0017n\u001d;ss\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDCA\u00181!\t\u0019\u0002\u0001C\u0003&Y\u0001\u0007q\u0005C\u00043\u0001\t\u0007IQA\u001a\u0002\u00035+\u0012\u0001N\b\u0002k}!\u0011\n!\u0001\u0001\u0011\u00199\u0004\u0001)A\u0007i\u0005\u0011Q\n\t\u0005\bs\u0001\u0011\r\u0011\"\u0002;\u0003\r\u00016\tV\u000b\u0002w=\tA\b\t\u0005A3\u0002\u0001\u0001\u0001\u0001\u0001\u0001\u0011\u0019q\u0004\u0001)A\u0007w\u0005!\u0001k\u0011+!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000bA\"\\3n_JLX\n\u0017\"fC:,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bb\t!\"\\1oC\u001e,W.\u001a8u\u0013\t9EI\u0001\u0007NK6|'/_'Y\u0005\u0016\fg\u000e\u0003\u0004J\u0001\u0001\u0006IAQ\u0001\u000e[\u0016lwN]=N1\n+\u0017M\u001c\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u00069qm\u0019\"fC:\u001cX#A'\u0011\u00079\u0003&+D\u0001P\u0015\t\t#$\u0003\u0002R\u001f\n!A*[:u!\t\u00195+\u0003\u0002U\t\n1r)\u0019:cC\u001e,7i\u001c7mK\u000e$xN]'Y\u0005\u0016\fg\u000e\u0003\u0004W\u0001\u0001\u0006I!T\u0001\tO\u000e\u0014U-\u00198tA!9\u0001\f\u0001b\u0001\n\u0003I\u0016\u0001\u0004;ie\u0016\fG-\u0014-CK\u0006tW#\u0001.\u0011\u0005\r[\u0016B\u0001/E\u00051!\u0006N]3bI6C&)Z1o\u0011\u0019q\u0006\u0001)A\u00055\u0006iA\u000f\u001b:fC\u0012l\u0005LQ3b]\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-\u0001\u0005pg6C&)Z1o+\u0005\u0011\u0007CA\"d\u0013\t!GIA\u000bPa\u0016\u0014\u0018\r^5oONK8\u000f^3n\u001bb\u0013U-\u00198\t\r\u0019\u0004\u0001\u0015!\u0003c\u0003%y7/\u0014-CK\u0006t\u0007\u0005C\u0004i\u0001\u0001\u0007I\u0011A5\u0002\u001d\u001d\u001c')Z1o\u0007>,h\u000e^3sgV\t!\u000e\u0005\u0003l]B<X\"\u00017\u000b\u00055t\u0011AC2pY2,7\r^5p]&\u0011q\u000e\u001c\u0002\u0004\u001b\u0006\u0004\bCA9u\u001d\ti!/\u0003\u0002t\u001d\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019h\u0002\u0005\u0003\u000eqjT\u0018BA=\u000f\u0005\u0019!V\u000f\u001d7feA\u00111c_\u0005\u0003y\n\u0011qaQ8v]R,'\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011A@\u0002%\u001d\u001c')Z1o\u0007>,h\u000e^3sg~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0001E\u0002\u000e\u0003\u0007I1!!\u0002\u000f\u0005\u0011)f.\u001b;\t\u0011\u0005%Q0!AA\u0002)\f1\u0001\u001f\u00132\u0011\u001d\ti\u0001\u0001Q!\n)\fqbZ2CK\u0006t7i\\;oi\u0016\u00148\u000f\t\u0005\n\u0003#\u0001!\u0019!C\u0001\u0003'\t\u0001\"\u001a=fGV$xN]\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037y\u0015AC2p]\u000e,(O]3oi&!\u0011qDA\r\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0016\u0005IQ\r_3dkR|'\u000f\t\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003S\t\u0001cZ'f[:{g\u000eS3baV\u001bX\rZ'\u0016\u0005\u0005-\u0002#B\n\u0002.\u0005E\u0012bAA\u0018\u0005\t)q)Y;hKB\u0019Q\"a\r\n\u0007\u0005UbBA\u0003GY>\fG\u000f\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0016\u0003E9W*Z7O_:DU-\u00199Vg\u0016$W\n\t\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003S\tQcZ'f[:{g\u000eS3ba\u000e{W.\\5ui\u0016$W\n\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0016\u0003Y9W*Z7O_:DU-\u00199D_6l\u0017\u000e\u001e;fI6\u0003\u0003\"CA#\u0001\t\u0007I\u0011AA\u0015\u0003=9W*Z7O_:DU-\u00199NCbl\u0005\u0002CA%\u0001\u0001\u0006I!a\u000b\u0002!\u001dlU-\u001c(p]\"+\u0017\r]'bq6\u0003\u0003\"CA'\u0001\t\u0007I\u0011AA\u0015\u000359W*Z7IK\u0006\u0004Xk]3e\u001b\"A\u0011\u0011\u000b\u0001!\u0002\u0013\tY#\u0001\bh\u001b\u0016l\u0007*Z1q+N,G-\u0014\u0011\t\u0013\u0005U\u0003A1A\u0005\u0002\u0005%\u0012AE4NK6DU-\u00199D_6l\u0017\u000e\u001e;fI6C\u0001\"!\u0017\u0001A\u0003%\u00111F\u0001\u0014O6+W\u000eS3ba\u000e{W.\\5ui\u0016$W\n\t\u0005\n\u0003;\u0002!\u0019!C\u0001\u0003S\tAbZ'f[\"+\u0017\r]'bq6C\u0001\"!\u0019\u0001A\u0003%\u00111F\u0001\u000eO6+W\u000eS3ba6\u000b\u00070\u0014\u0011\t\u0013\u0005\u0015\u0004A1A\u0005\u0002\u0005\u001d\u0014aC4UQJ,\u0017\rZ:OK^,\"!!\u001b\u0011\u000bM\ti#a\u001b\u0011\u00075\ti'C\u0002\u0002p9\u0011A\u0001T8oO\"A\u00111\u000f\u0001!\u0002\u0013\tI'\u0001\u0007h)\"\u0014X-\u00193t\u001d\u0016<\b\u0005C\u0005\u0002x\u0001\u0011\r\u0011\"\u0001\u0002h\u0005\u0001r\r\u00165sK\u0006$7OU;o]\u0006\u0014G.\u001a\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002j\u0005\tr\r\u00165sK\u0006$7OU;o]\u0006\u0014G.\u001a\u0011\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\u001d\u0014aD4UQJ,\u0017\rZ:CY>\u001c7.\u001a3\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003S\n\u0001c\u001a+ie\u0016\fGm\u001d\"m_\u000e\\W\r\u001a\u0011\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005\u001d\u0014aD4UQJ,\u0017\rZ:XC&$\u0018N\\4\t\u0011\u0005-\u0005\u0001)A\u0005\u0003S\n\u0001c\u001a+ie\u0016\fGm],bSRLgn\u001a\u0011\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005\u001d\u0014\u0001F4UQJ,\u0017\rZ:US6,GmV1ji&tw\r\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BA5\u0003U9G\u000b\u001b:fC\u0012\u001cH+[7fI^\u000b\u0017\u000e^5oO\u0002B\u0011\"a&\u0001\u0005\u0004%\t!a\u001a\u0002%\u001d$\u0006N]3bIN$VM]7j]\u0006$X\r\u001a\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002j\u0005\u0019r\r\u00165sK\u0006$7\u000fV3s[&t\u0017\r^3eA!I\u0011q\u0014\u0001C\u0002\u0013\u0005\u0011\u0011U\u0001\tG\u001e\u001b7i\\;oiV\t!\u0010C\u0004\u0002&\u0002\u0001\u000b\u0011\u0002>\u0002\u0013\r<5mQ8v]R\u0004\u0003\"CAU\u0001\t\u0007I\u0011AAQ\u00035\u0019wi\u0019+j[\u0016l\u0015\u000e\u001c7jg\"9\u0011Q\u0016\u0001!\u0002\u0013Q\u0018AD2HGRKW.Z'jY2L7\u000f\t\u0005\n\u0003c\u0003!\u0019!C\u0001\u0003g\u000b\u0001c\u001a)s_\u000e,7o]\"qkV\u001b\u0018mZ3\u0016\u0005\u0005U\u0006#B\n\u0002.\u0005]\u0006cA\u0007\u0002:&\u0019\u00111\u0018\b\u0003\r\u0011{WO\u00197f\u0011!\ty\f\u0001Q\u0001\n\u0005U\u0016!E4Qe>\u001cWm]:DaV,6/Y4fA!I\u00111\u0019\u0001C\u0002\u0013\u0005\u00111W\u0001\u0010ONK8\u000f^3n\u0007B,Xk]1hK\"A\u0011q\u0019\u0001!\u0002\u0013\t),\u0001\th'f\u001cH/Z7DaV,6/Y4fA!I\u00111\u001a\u0001C\u0002\u0013\u0005\u00111W\u0001\u0019O>\u0003XM\u001c$jY\u0016$Um]2sSB$xN]\"pk:$\b\u0002CAh\u0001\u0001\u0006I!!.\u00023\u001d|\u0005/\u001a8GS2,G)Z:de&\u0004Ho\u001c:D_VtG\u000f\t\u0005\b\u0003'\u0004A\u0011AAk\u0003\u0015\u0019H/\u0019:u+\t\t\t\u0001C\u0004\u0002Z\u0002!\t!a7\u0002\u0007I,h\u000e\u0006\u0002\u0002\u0002!9\u0011q\u001c\u0001\u0005\u0002\u0005U\u0017\u0001B:u_BDq!a9\u0001\t\u0013\t).A\tva\u0012\fG/Z'f[>\u0014\u00180V:bO\u0016Dq!a:\u0001\t\u0013\t).A\u0007va\u0012\fG/Z$d+N\fw-\u001a\u0005\b\u0003W\u0004A\u0011BAw\u0003%9W\r^$d\u0013:4w\u000eF\u0002x\u0003_Dq!!=\u0002j\u0002\u0007\u0001/\u0001\u0004hG:\u000bW.\u001a\u0005\b\u0003k\u0004A\u0011BAk\u0003E)\b\u000fZ1uKRC'/Z1e+N\fw-\u001a\u0005\b\u0003s\u0004A\u0011BAk\u0003q)\b\u000fZ1uK>\u0003XM]1uS:<7+_:uK6lU\r\u001e:jGN\u0004")
public class JvmMetrics
implements MetricsHelper,
Runnable,
Logging {
    private final MetricsRegistry registry;
    private final float M;
    private final double PCT;
    private final MemoryMXBean memoryMXBean;
    private final List<GarbageCollectorMXBean> gcBeans;
    private final ThreadMXBean threadMXBean;
    private final OperatingSystemMXBean osMXBean;
    private Map<String, Tuple2<Counter, Counter>> gcBeanCounters;
    private final ScheduledExecutorService executor;
    private final Gauge<Object> gMemNonHeapUsedM;
    private final Gauge<Object> gMemNonHeapCommittedM;
    private final Gauge<Object> gMemNonHeapMaxM;
    private final Gauge<Object> gMemHeapUsedM;
    private final Gauge<Object> gMemHeapCommittedM;
    private final Gauge<Object> gMemHeapMaxM;
    private final Gauge<Object> gThreadsNew;
    private final Gauge<Object> gThreadsRunnable;
    private final Gauge<Object> gThreadsBlocked;
    private final Gauge<Object> gThreadsWaiting;
    private final Gauge<Object> gThreadsTimedWaiting;
    private final Gauge<Object> gThreadsTerminated;
    private final Counter cGcCount;
    private final Counter cGcTimeMillis;
    private final Gauge<Object> gProcessCpuUsage;
    private final Gauge<Object> gSystemCpuUsage;
    private final Gauge<Object> gOpenFileDescriptorCount;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private final String group;
    private final MetricGroup metricGroup;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        JvmMetrics jvmMetrics = this;
        synchronized (jvmMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        JvmMetrics jvmMetrics = this;
        synchronized (jvmMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public MetricGroup metricGroup() {
        return this.metricGroup;
    }

    @Override
    public void org$apache$samza$metrics$MetricsHelper$_setter_$group_$eq(String x$1) {
        this.group = x$1;
    }

    @Override
    public void org$apache$samza$metrics$MetricsHelper$_setter_$metricGroup_$eq(MetricGroup x$1) {
        this.metricGroup = x$1;
    }

    @Override
    public Counter newCounter(String name) {
        return MetricsHelper$class.newCounter(this, name);
    }

    @Override
    public Timer newTimer(String name) {
        return MetricsHelper$class.newTimer(this, name);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, T value) {
        return MetricsHelper$class.newGauge((MetricsHelper)this, name, value);
    }

    @Override
    public <T> ListGauge<T> newListGauge(String name) {
        return MetricsHelper$class.newListGauge(this, name);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Function0<T> value) {
        return MetricsHelper$class.newGauge((MetricsHelper)this, name, value);
    }

    @Override
    public String getPrefix() {
        return MetricsHelper$class.getPrefix(this);
    }

    @Override
    public MetricsRegistry registry() {
        return this.registry;
    }

    public final float M() {
        return 1048576.0f;
    }

    public final double PCT() {
        return 100.0;
    }

    public MemoryMXBean memoryMXBean() {
        return this.memoryMXBean;
    }

    public List<GarbageCollectorMXBean> gcBeans() {
        return this.gcBeans;
    }

    public ThreadMXBean threadMXBean() {
        return this.threadMXBean;
    }

    public OperatingSystemMXBean osMXBean() {
        return this.osMXBean;
    }

    public Map<String, Tuple2<Counter, Counter>> gcBeanCounters() {
        return this.gcBeanCounters;
    }

    public void gcBeanCounters_$eq(Map<String, Tuple2<Counter, Counter>> x$1) {
        this.gcBeanCounters = x$1;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Gauge<Object> gMemNonHeapUsedM() {
        return this.gMemNonHeapUsedM;
    }

    public Gauge<Object> gMemNonHeapCommittedM() {
        return this.gMemNonHeapCommittedM;
    }

    public Gauge<Object> gMemNonHeapMaxM() {
        return this.gMemNonHeapMaxM;
    }

    public Gauge<Object> gMemHeapUsedM() {
        return this.gMemHeapUsedM;
    }

    public Gauge<Object> gMemHeapCommittedM() {
        return this.gMemHeapCommittedM;
    }

    public Gauge<Object> gMemHeapMaxM() {
        return this.gMemHeapMaxM;
    }

    public Gauge<Object> gThreadsNew() {
        return this.gThreadsNew;
    }

    public Gauge<Object> gThreadsRunnable() {
        return this.gThreadsRunnable;
    }

    public Gauge<Object> gThreadsBlocked() {
        return this.gThreadsBlocked;
    }

    public Gauge<Object> gThreadsWaiting() {
        return this.gThreadsWaiting;
    }

    public Gauge<Object> gThreadsTimedWaiting() {
        return this.gThreadsTimedWaiting;
    }

    public Gauge<Object> gThreadsTerminated() {
        return this.gThreadsTerminated;
    }

    public Counter cGcCount() {
        return this.cGcCount;
    }

    public Counter cGcTimeMillis() {
        return this.cGcTimeMillis;
    }

    public Gauge<Object> gProcessCpuUsage() {
        return this.gProcessCpuUsage;
    }

    public Gauge<Object> gSystemCpuUsage() {
        return this.gSystemCpuUsage;
    }

    public Gauge<Object> gOpenFileDescriptorCount() {
        return this.gOpenFileDescriptorCount;
    }

    public void start() {
        this.executor().scheduleWithFixedDelay(this, 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "updating jvm metrics";
            }
        });
        this.updateMemoryUsage();
        this.updateGcUsage();
        this.updateThreadUsage();
        this.updateOperatingSystemMetrics();
        this.debug((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JvmMetrics $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("updated metrics to: [%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.gMemNonHeapUsedM(), this.$outer.gMemNonHeapCommittedM(), this.$outer.gMemNonHeapMaxM(), this.$outer.gMemHeapUsedM(), this.$outer.gMemHeapCommittedM(), this.$outer.gMemHeapMaxM(), this.$outer.gThreadsNew(), this.$outer.gThreadsRunnable(), this.$outer.gThreadsBlocked(), this.$outer.gThreadsWaiting(), this.$outer.gThreadsTimedWaiting(), this.$outer.gThreadsTerminated(), this.$outer.cGcCount(), this.$outer.cGcTimeMillis(), this.$outer.gProcessCpuUsage(), this.$outer.gSystemCpuUsage(), this.$outer.gOpenFileDescriptorCount()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void stop() {
        this.executor().shutdown();
    }

    private void updateMemoryUsage() {
        MemoryUsage memNonHeap = this.memoryMXBean().getNonHeapMemoryUsage();
        MemoryUsage memHeap = this.memoryMXBean().getHeapMemoryUsage();
        this.gMemNonHeapUsedM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memNonHeap.getUsed() / 1048576.0))));
        this.gMemNonHeapCommittedM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memNonHeap.getCommitted() / 1048576.0))));
        this.gMemNonHeapMaxM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memNonHeap.getMax() / 1048576.0))));
        this.gMemHeapUsedM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memHeap.getUsed() / 1048576.0))));
        this.gMemHeapCommittedM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memHeap.getCommitted() / 1048576.0))));
        this.gMemHeapMaxM().set((Object)BoxesRunTime.boxToFloat((float)((float)((double)memHeap.getMax() / 1048576.0))));
    }

    private void updateGcUsage() {
        LongRef count = LongRef.create((long)0L);
        LongRef timeMillis = LongRef.create((long)0L);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.gcBeans()).asScala()).foreach((Function1)new Serializable(this, count, timeMillis){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JvmMetrics $outer;
            private final LongRef count$1;
            private final LongRef timeMillis$1;

            public final void apply(GarbageCollectorMXBean gcBean) {
                long c = gcBean.getCollectionCount();
                long t = gcBean.getCollectionTime();
                Tuple2<Counter, Counter> gcInfo = this.$outer.org$apache$samza$metrics$JvmMetrics$$getGcInfo(gcBean.getName());
                ((Counter)gcInfo._1()).inc(c - ((Counter)gcInfo._1()).getCount());
                ((Counter)gcInfo._2()).inc(t - ((Counter)gcInfo._2()).getCount());
                this.count$1.elem += c;
                this.timeMillis$1.elem += t;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
                this.timeMillis$1 = timeMillis$1;
            }
        });
        this.cGcCount().inc(count.elem - this.cGcCount().getCount());
        this.cGcTimeMillis().inc(timeMillis.elem - this.cGcTimeMillis().getCount());
    }

    public Tuple2<Counter, Counter> org$apache$samza$metrics$JvmMetrics$$getGcInfo(String gcName) {
        Tuple2 tuple2;
        Option option = this.gcBeanCounters().get((Object)gcName);
        if (option instanceof Some) {
            Tuple2 gcBeanCounterTuple;
            Some some = (Some)option;
            tuple2 = gcBeanCounterTuple = (Tuple2)some.x();
        } else {
            Tuple2 t = new Tuple2((Object)this.newCounter(new StringOps(Predef$.MODULE$.augmentString("%s-gc-count")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcName}))), (Object)this.newCounter(new StringOps(Predef$.MODULE$.augmentString("%s-gc-time-millis")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcName}))));
            this.gcBeanCounters_$eq((Map<String, Tuple2<Counter, Counter>>)this.gcBeanCounters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gcName), (Object)t)));
            tuple2 = t;
        }
        return tuple2;
    }

    private void updateThreadUsage() {
        LongRef threadsNew = LongRef.create((long)0L);
        LongRef threadsRunnable = LongRef.create((long)0L);
        LongRef threadsBlocked = LongRef.create((long)0L);
        LongRef threadsWaiting = LongRef.create((long)0L);
        LongRef threadsTimedWaiting = LongRef.create((long)0L);
        LongRef threadsTerminated = LongRef.create((long)0L);
        long[] threadIds = this.threadMXBean().getAllThreadIds();
        Predef$.MODULE$.refArrayOps((Object[])this.threadMXBean().getThreadInfo(threadIds, 0)).foreach((Function1)new Serializable(this, threadsNew, threadsRunnable, threadsBlocked, threadsWaiting, threadsTimedWaiting, threadsTerminated){
            public static final long serialVersionUID = 0L;
            private final LongRef threadsNew$1;
            private final LongRef threadsRunnable$1;
            private final LongRef threadsBlocked$1;
            private final LongRef threadsWaiting$1;
            private final LongRef threadsTimedWaiting$1;
            private final LongRef threadsTerminated$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(ThreadInfo threadInfo) {
                Option option = Option$.MODULE$.apply((Object)threadInfo);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ThreadInfo threadInfo2 = (ThreadInfo)some.x();
                    Thread.State state = threadInfo2.getThreadState();
                    if (((Object)((Object)Thread.State.NEW)).equals((Object)((Object)state))) {
                        ++this.threadsNew$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (((Object)((Object)Thread.State.RUNNABLE)).equals((Object)((Object)state))) {
                        ++this.threadsRunnable$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (((Object)((Object)Thread.State.BLOCKED)).equals((Object)((Object)state))) {
                        ++this.threadsBlocked$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (((Object)((Object)Thread.State.WAITING)).equals((Object)((Object)state))) {
                        ++this.threadsWaiting$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (((Object)((Object)Thread.State.TIMED_WAITING)).equals((Object)((Object)state))) {
                        ++this.threadsTimedWaiting$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (!((Object)((Object)Thread.State.TERMINATED)).equals((Object)((Object)state))) throw new MatchError((Object)((Object)state));
                        ++this.threadsTerminated$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.threadsNew$1 = threadsNew$1;
                this.threadsRunnable$1 = threadsRunnable$1;
                this.threadsBlocked$1 = threadsBlocked$1;
                this.threadsWaiting$1 = threadsWaiting$1;
                this.threadsTimedWaiting$1 = threadsTimedWaiting$1;
                this.threadsTerminated$1 = threadsTerminated$1;
            }
        });
        this.gThreadsNew().set((Object)BoxesRunTime.boxToLong((long)threadsNew.elem));
        this.gThreadsRunnable().set((Object)BoxesRunTime.boxToLong((long)threadsRunnable.elem));
        this.gThreadsBlocked().set((Object)BoxesRunTime.boxToLong((long)threadsBlocked.elem));
        this.gThreadsWaiting().set((Object)BoxesRunTime.boxToLong((long)threadsWaiting.elem));
        this.gThreadsTimedWaiting().set((Object)BoxesRunTime.boxToLong((long)threadsTimedWaiting.elem));
        this.gThreadsTerminated().set((Object)BoxesRunTime.boxToLong((long)threadsTerminated.elem));
    }

    private void updateOperatingSystemMetrics() {
        if (this.osMXBean() instanceof com.sun.management.OperatingSystemMXBean) {
            com.sun.management.OperatingSystemMXBean operatingSystemMXBean = (com.sun.management.OperatingSystemMXBean)this.osMXBean();
            this.gProcessCpuUsage().set((Object)BoxesRunTime.boxToDouble((double)(operatingSystemMXBean.getProcessCpuLoad() * 100.0)));
            this.gSystemCpuUsage().set((Object)BoxesRunTime.boxToDouble((double)(operatingSystemMXBean.getSystemCpuLoad() * 100.0)));
            if (this.osMXBean() instanceof UnixOperatingSystemMXBean) {
                this.gOpenFileDescriptorCount().set((Object)BoxesRunTime.boxToDouble((double)((UnixOperatingSystemMXBean)this.osMXBean()).getOpenFileDescriptorCount()));
            }
        }
    }

    public JvmMetrics(MetricsRegistry registry) {
        this.registry = registry;
        MetricsHelper$class.$init$(this);
        Logging$class.$init$(this);
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.gcBeanCounters = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Samza JvmMetrics Thread-%d").setDaemon(true).build());
        this.gMemNonHeapUsedM = this.newGauge("mem-non-heap-used-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gMemNonHeapCommittedM = this.newGauge("mem-non-heap-committed-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gMemNonHeapMaxM = this.newGauge("mem-non-heap-max-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gMemHeapUsedM = this.newGauge("mem-heap-used-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gMemHeapCommittedM = this.newGauge("mem-heap-committed-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gMemHeapMaxM = this.newGauge("mem-heap-max-mb", BoxesRunTime.boxToFloat((float)0.0f));
        this.gThreadsNew = this.newGauge("threads-new", BoxesRunTime.boxToLong((long)0L));
        this.gThreadsRunnable = this.newGauge("threads-runnable", BoxesRunTime.boxToLong((long)0L));
        this.gThreadsBlocked = this.newGauge("threads-blocked", BoxesRunTime.boxToLong((long)0L));
        this.gThreadsWaiting = this.newGauge("threads-waiting", BoxesRunTime.boxToLong((long)0L));
        this.gThreadsTimedWaiting = this.newGauge("threads-timed-waiting", BoxesRunTime.boxToLong((long)0L));
        this.gThreadsTerminated = this.newGauge("threads-terminated", BoxesRunTime.boxToLong((long)0L));
        this.cGcCount = this.newCounter("gc-count");
        this.cGcTimeMillis = this.newCounter("gc-time-millis");
        this.gProcessCpuUsage = this.osMXBean() instanceof com.sun.management.OperatingSystemMXBean ? this.newGauge("process-cpu-usage", BoxesRunTime.boxToDouble((double)0.0)) : null;
        this.gSystemCpuUsage = this.osMXBean() instanceof com.sun.management.OperatingSystemMXBean ? this.newGauge("system-cpu-usage", BoxesRunTime.boxToDouble((double)0.0)) : null;
        this.gOpenFileDescriptorCount = this.osMXBean() instanceof UnixOperatingSystemMXBean ? this.newGauge("open-file-descriptor-count", BoxesRunTime.boxToDouble((double)0.0)) : null;
    }
}

