/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtil {
    private static final Logger log = LoggerFactory.getLogger(JmxUtil.class);

    public static ObjectName getObjectName(String group, String name, String t) throws MalformedObjectNameException {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(JmxUtil.makeNameJmxSafe(group));
        nameBuilder.append(":type=");
        nameBuilder.append(JmxUtil.makeNameJmxSafe(t));
        nameBuilder.append(",name=");
        nameBuilder.append(JmxUtil.makeNameJmxSafe(name));
        ObjectName objName = new ObjectName(nameBuilder.toString());
        log.debug("Resolved name for " + group + ", " + name + ", " + t + " to: " + objName);
        return objName;
    }

    public static String makeNameJmxSafe(String str) {
        return str.replace(",", "_").replace("=", "_").replace(":", "_").replace("\"", "_").replace("*", "_").replace("?", "_");
    }
}

