/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.samza.metrics.JmxUtil;
import org.apache.samza.metrics.MetricsAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsAccessor
implements MetricsAccessor {
    private static final Logger log = LoggerFactory.getLogger(JmxMetricsAccessor.class);
    private final String url;
    private JMXConnector jmxc;

    public JmxMetricsAccessor(String url) {
        this.url = url;
    }

    public void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(this.url);
        this.jmxc = JMXConnectorFactory.connect(jmxUrl, null);
    }

    public void close() throws IOException {
        this.jmxc.close();
    }

    private <T> Map<String, T> getMetricValues(String group, String metric, String attribute) {
        try {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(JmxUtil.makeNameJmxSafe(group));
            nameBuilder.append(":type=*,name=");
            nameBuilder.append(JmxUtil.makeNameJmxSafe(metric));
            ObjectName query = new ObjectName(nameBuilder.toString());
            HashMap<String, Object> values = new HashMap<String, Object>();
            MBeanServerConnection conn = this.jmxc.getMBeanServerConnection();
            for (ObjectName objName : conn.queryNames(query, null)) {
                String type = objName.getKeyProperty("type");
                Object val = conn.getAttribute(objName, attribute);
                values.put(type, val);
            }
            return values;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    public Map<String, Long> getCounterValues(String group, String counter) {
        return this.getMetricValues(group, counter, "Count");
    }

    public <T> Map<String, T> getGaugeValues(String group, String gauge) {
        return this.getMetricValues(group, gauge, "Value");
    }

    public Map<String, Double> getTimerValues(String group, String timer) {
        return this.getMetricValues(group, timer, "AverageTime");
    }
}

