/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.config.Config;
import org.apache.samza.config.MetricsConfig$;
import org.apache.samza.metrics.ContainerProcessManagerMetrics$;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.JvmMetrics;
import org.apache.samza.metrics.ListGauge;
import org.apache.samza.metrics.MetricGroup;
import org.apache.samza.metrics.MetricsHelper;
import org.apache.samza.metrics.MetricsHelper$class;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.metrics.ReadableMetricsRegistry;
import org.apache.samza.metrics.Timer;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.apache.samza.util.MetricsReporterLoader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q<Q!\u0001\u0002\t\u0002-\tadQ8oi\u0006Lg.\u001a:Qe>\u001cWm]:NC:\fw-\u001a:NKR\u0014\u0018nY:\u000b\u0005\r!\u0011aB7fiJL7m\u001d\u0006\u0003\u000b\u0019\tQa]1nu\u0006T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!AH\"p]R\f\u0017N\\3s!J|7-Z:t\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2t'\ti\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/5!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AqAG\u0007C\u0002\u0013\u00051$\u0001\u0006t_V\u00148-\u001a(b[\u0016,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q%\u0004Q\u0001\nq\t1b]8ve\u000e,g*Y7fA\u0019!aB\u0001\u0001('\u00111\u0003\u0003K\u0016\u0011\u00051I\u0013B\u0001\u0016\u0003\u00055iU\r\u001e:jGNDU\r\u001c9feB\u0011AfL\u0007\u0002[)\u0011a\u0006B\u0001\u0005kRLG.\u0003\u00021[\t9Aj\\4hS:<\u0007\u0002\u0003\u001a'\u0005\u000b\u0007I\u0011A\u001a\u0002\r\r|gNZ5h+\u0005!\u0004CA\u001b8\u001b\u00051$B\u0001\u001a\u0005\u0013\tAdG\u0001\u0004D_:4\u0017n\u001a\u0005\tu\u0019\u0012\t\u0011)A\u0005i\u000591m\u001c8gS\u001e\u0004\u0003\u0002\u0003\u001f'\u0005\u000b\u0007I\u0011A\u001f\u0002\u000bM$\u0018\r^3\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\u001d\rdWo\u001d;fe6\fg.Y4fe&\u00111\t\u0011\u0002\u0016'\u0006l'0Y!qa2L7-\u0019;j_:\u001cF/\u0019;f\u0011!)eE!A!\u0002\u0013q\u0014AB:uCR,\u0007\u0005\u0003\u0005HM\t\u0015\r\u0011\"\u0001I\u0003!\u0011XmZ5tiJLX#A%\u0011\u00051Q\u0015BA&\u0003\u0005]\u0011V-\u00193bE2,W*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010\u0003\u0005NM\t\u0005\t\u0015!\u0003J\u0003%\u0011XmZ5tiJL\b\u0005C\u0003\u0018M\u0011\u0005q\n\u0006\u0003Q#J\u001b\u0006C\u0001\u0007'\u0011\u0015\u0011d\n1\u00015\u0011\u0015ad\n1\u0001?\u0011\u00159e\n1\u0001J\u0011\u001d)fE1A\u0005\u0002Y\u000b1A\u001b<n+\u00059\u0006C\u0001\u0007Y\u0013\tI&A\u0001\u0006Km6lU\r\u001e:jGNDaa\u0017\u0014!\u0002\u00139\u0016\u0001\u00026w[\u0002Bq!\u0018\u0014C\u0002\u0013\u0005a,A\u0005sKB|'\u000f^3sgV\tq\f\u0005\u0003aKr9W\"A1\u000b\u0005\t\u001c\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003IJ\t!bY8mY\u0016\u001cG/[8o\u0013\t1\u0017MA\u0002NCB\u0004\"\u0001\u00045\n\u0005%\u0014!aD'fiJL7m\u001d*fa>\u0014H/\u001a:\t\r-4\u0003\u0015!\u0003`\u0003)\u0011X\r]8si\u0016\u00148\u000f\t\u0005\u0006[\u001a\"\tA\\\u0001\u0006gR\f'\u000f\u001e\u000b\u0002_B\u0011\u0011\u0003]\u0005\u0003cJ\u0011A!\u00168ji\")1O\nC\u0001]\u0006!1\u000f^8q\u0001")
public class ContainerProcessManagerMetrics
implements MetricsHelper,
Logging {
    private final Config config;
    private final SamzaApplicationState state;
    private final ReadableMetricsRegistry registry;
    private final JvmMetrics jvm;
    private final Map<String, MetricsReporter> reporters;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private final String group;
    private final MetricGroup metricGroup;
    private volatile byte bitmap$0;

    public static String sourceName() {
        return ContainerProcessManagerMetrics$.MODULE$.sourceName();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ContainerProcessManagerMetrics containerProcessManagerMetrics = this;
        synchronized (containerProcessManagerMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        ContainerProcessManagerMetrics containerProcessManagerMetrics = this;
        synchronized (containerProcessManagerMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public MetricGroup metricGroup() {
        return this.metricGroup;
    }

    @Override
    public void org$apache$samza$metrics$MetricsHelper$_setter_$group_$eq(String x$1) {
        this.group = x$1;
    }

    @Override
    public void org$apache$samza$metrics$MetricsHelper$_setter_$metricGroup_$eq(MetricGroup x$1) {
        this.metricGroup = x$1;
    }

    @Override
    public Counter newCounter(String name) {
        return MetricsHelper$class.newCounter(this, name);
    }

    @Override
    public Timer newTimer(String name) {
        return MetricsHelper$class.newTimer(this, name);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, T value) {
        return MetricsHelper$class.newGauge((MetricsHelper)this, name, value);
    }

    @Override
    public <T> ListGauge<T> newListGauge(String name) {
        return MetricsHelper$class.newListGauge(this, name);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Function0<T> value) {
        return MetricsHelper$class.newGauge((MetricsHelper)this, name, value);
    }

    @Override
    public String getPrefix() {
        return MetricsHelper$class.getPrefix(this);
    }

    public Config config() {
        return this.config;
    }

    public SamzaApplicationState state() {
        return this.state;
    }

    public ReadableMetricsRegistry registry() {
        return this.registry;
    }

    public JvmMetrics jvm() {
        return this.jvm;
    }

    public Map<String, MetricsReporter> reporters() {
        return this.reporters;
    }

    public void start() {
        Gauge mRunningContainers = this.newGauge("running-containers", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().runningContainers.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mNeededContainers = this.newGauge("needed-containers", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().neededContainers.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mCompletedContainers = this.newGauge("completed-containers", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().completedContainers.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mFailedContainers = this.newGauge("failed-containers", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().failedContainers.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mReleasedContainers = this.newGauge("released-containers", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().releasedContainers.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mContainers = this.newGauge("container-count", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final AtomicInteger apply() {
                return this.$outer.state().containerCount;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mRedundantNotifications = this.newGauge("redundant-notifications", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().redundantNotifications.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mJobHealthy = this.newGauge("job-healthy", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().jobHealthy.get() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mPreferredHostRequests = this.newGauge("preferred-host-requests", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().preferredHostRequests.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mAnyHostRequests = this.newGauge("any-host-requests", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().anyHostRequests.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mExpiredPreferredHostRequests = this.newGauge("expired-preferred-host-requests", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().expiredPreferredHostRequests.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mExpiredAnyHostRequests = this.newGauge("expired-any-host-requests", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.state().expiredAnyHostRequests.get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Gauge mHostAffinityMatchPct = this.newGauge("host-affinity-match-pct", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                int numPreferredHostRequests = this.$outer.state().preferredHostRequests.get();
                int numExpiredPreferredHostRequests = this.$outer.state().expiredPreferredHostRequests.get();
                return numPreferredHostRequests != 0 ? 100.0 * (double)(numPreferredHostRequests - numExpiredPreferredHostRequests) / (double)numPreferredHostRequests : 0.0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.jvm().start();
        this.reporters().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MetricsReporter x$2) {
                x$2.start();
            }
        });
    }

    public void stop() {
        this.reporters().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MetricsReporter x$3) {
                x$3.stop();
            }
        });
    }

    public ContainerProcessManagerMetrics(Config config, SamzaApplicationState state, ReadableMetricsRegistry registry) {
        this.config = config;
        this.state = state;
        this.registry = registry;
        MetricsHelper$class.$init$(this);
        Logging$class.$init$(this);
        this.jvm = new JvmMetrics((MetricsRegistry)registry);
        this.reporters = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(MetricsReporterLoader.getMetricsReporters(MetricsConfig$.MODULE$.Config2Metrics(config), ContainerProcessManagerMetrics$.MODULE$.sourceName())).asScala();
        this.reporters().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerProcessManagerMetrics $outer;

            public final void apply(MetricsReporter x$1) {
                x$1.register(ContainerProcessManagerMetrics$.MODULE$.sourceName(), this.$outer.registry());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

