/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.container.LocalityManager;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.TaskModel;

public class JobModel {
    private static final String EMPTY_STRING = "";
    private final Config config;
    private final Map<String, ContainerModel> containers;
    private final LocalityManager localityManager;
    private final Map<String, String> localityMappings;
    public int maxChangeLogStreamPartitions;

    public JobModel(Config config, Map<String, ContainerModel> containers) {
        this(config, containers, null);
    }

    public JobModel(Config config, Map<String, ContainerModel> containers, LocalityManager localityManager) {
        this.config = config;
        this.containers = Collections.unmodifiableMap(containers);
        this.localityManager = localityManager;
        this.localityMappings = new HashMap<String, String>();
        if (localityManager == null) {
            for (String containerId : containers.keySet()) {
                this.localityMappings.put(containerId, null);
            }
        } else {
            this.populateContainerLocalityMappings();
        }
        this.maxChangeLogStreamPartitions = 0;
        for (ContainerModel container : containers.values()) {
            for (TaskModel task : container.getTasks().values()) {
                if (this.maxChangeLogStreamPartitions >= task.getChangelogPartition().getPartitionId() + 1) continue;
                this.maxChangeLogStreamPartitions = task.getChangelogPartition().getPartitionId() + 1;
            }
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public String getContainerToHostValue(String containerId, String key) {
        if (this.localityManager == null) {
            return EMPTY_STRING;
        }
        Map<String, String> mappings = this.localityManager.readContainerLocality().get(containerId);
        if (mappings == null) {
            return EMPTY_STRING;
        }
        if (!mappings.containsKey(key)) {
            return EMPTY_STRING;
        }
        return mappings.get(key);
    }

    public Map<String, String> getAllContainerToHostValues(String key) {
        if (this.localityManager == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> allValues = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> entry : this.localityManager.readContainerLocality().entrySet()) {
            String value = entry.getValue().get(key);
            if (value == null) continue;
            allValues.put(entry.getKey(), value);
        }
        return allValues;
    }

    private void populateContainerLocalityMappings() {
        Map<String, Map<String, String>> allMappings = this.localityManager.readContainerLocality();
        for (String containerId : this.containers.keySet()) {
            if (allMappings.containsKey(containerId)) {
                this.localityMappings.put(containerId, allMappings.get(containerId).get("host"));
                continue;
            }
            this.localityMappings.put(containerId, null);
        }
    }

    public Map<String, String> getAllContainerLocality() {
        if (this.localityManager != null) {
            this.populateContainerLocalityMappings();
        }
        return this.localityMappings;
    }

    public Map<String, ContainerModel> getContainers() {
        return this.containers;
    }

    public String toString() {
        return "JobModel [config=" + this.config + ", containers=" + this.containers + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.containers == null ? 0 : this.containers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobModel other = (JobModel)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.containers == null ? other.containers != null : !this.containers.equals(other.containers));
    }
}

