/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.local;

import org.apache.samza.application.ApplicationUtil;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.ApplicationDescriptorUtil;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.ShellCommandConfig$;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.container.SamzaContainer;
import org.apache.samza.container.SamzaContainer$;
import org.apache.samza.container.SamzaContainerListener;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationContainerContextFactory;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.context.JobContextImpl;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.coordinator.JobModelManager$;
import org.apache.samza.coordinator.stream.CoordinatorStreamManager;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.StreamJobFactory;
import org.apache.samza.job.local.ProcessJobFactory;
import org.apache.samza.job.local.ThreadJob;
import org.apache.samza.job.local.ThreadJobFactory$;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.JmxServer;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.metrics.MetricsReporter;
import org.apache.samza.runtime.ProcessorContext;
import org.apache.samza.runtime.ProcessorLifecycleListener;
import org.apache.samza.storage.ChangelogStreamManager;
import org.apache.samza.task.TaskFactory;
import org.apache.samza.task.TaskFactoryUtil;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u001b\t\u0001B\u000b\u001b:fC\u0012TuN\u0019$bGR|'/\u001f\u0006\u0003\u0007\u0011\tQ\u0001\\8dC2T!!\u0002\u0004\u0002\u0007)|'M\u0003\u0002\b\u0011\u0005)1/Y7{C*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\t\u00012\u000b\u001e:fC6TuN\u0019$bGR|'/\u001f\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\tA!\u001e;jY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0003'\u0001\u0011\u0005q%\u0001\u0004hKRTuN\u0019\u000b\u0003Q-\u0002\"aF\u0015\n\u0005)\"!!C*ue\u0016\fWNS8c\u0011\u0015aS\u00051\u0001.\u0003\u0019\u0019wN\u001c4jOB\u0011a\u0006M\u0007\u0002_)\u0011AFB\u0005\u0003c=\u0012aaQ8oM&<\u0007")
public class ThreadJobFactory
implements StreamJobFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ThreadJobFactory threadJobFactory = this;
        synchronized (threadJobFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        ThreadJobFactory threadJobFactory = this;
        synchronized (threadJobFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public StreamJob getJob(Config config) {
        None$ none$;
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating a ThreadJob, which is only meant for debugging.";
            }
        });
        MetricsRegistryMap metricsRegistry = new MetricsRegistryMap();
        CoordinatorStreamManager coordinatorStreamManager = new CoordinatorStreamManager(config, (MetricsRegistry)metricsRegistry);
        coordinatorStreamManager.register(this.getClass().getSimpleName());
        coordinatorStreamManager.start();
        coordinatorStreamManager.bootstrap();
        ChangelogStreamManager changelogStreamManager = new ChangelogStreamManager(coordinatorStreamManager);
        JobModelManager coordinator = JobModelManager$.MODULE$.apply(coordinatorStreamManager.getConfig(), changelogStreamManager.readPartitionMapping());
        JobModel jobModel = coordinator.jobModel();
        Map taskPartitionMappings = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        JavaConversions$.MODULE$.collectionAsScalaIterable(jobModel.getContainers().values()).foreach((Function1)new Serializable(this, taskPartitionMappings){
            public static final long serialVersionUID = 0L;
            public final Map taskPartitionMappings$1;

            public final void apply(ContainerModel containerModel) {
                JavaConversions$.MODULE$.collectionAsScalaIterable(containerModel.getTasks().values()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getJob$2 $outer;

                    public final Option<Integer> apply(TaskModel taskModel) {
                        return this.$outer.taskPartitionMappings$1.put((Object)taskModel.getTaskName(), (Object)Predef$.MODULE$.int2Integer(taskModel.getChangelogPartition().getPartitionId()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.taskPartitionMappings$1 = taskPartitionMappings$1;
            }
        });
        changelogStreamManager.writePartitionMapping(JavaConversions$.MODULE$.mutableMapAsJavaMap(taskPartitionMappings));
        CheckpointManager checkpointManager = new TaskConfigJava(jobModel.getConfig()).getCheckpointManager((MetricsRegistry)metricsRegistry);
        if (checkpointManager != null) {
            checkpointManager.createResources();
            checkpointManager.stop();
        }
        ChangelogStreamManager.createChangelogStreams(jobModel.getConfig(), jobModel.maxChangeLogStreamPartitions);
        String containerId = "0";
        JmxServer jmxServer = null;
        if (new JobConfig(config).getJMXEnabled()) {
            jmxServer = new JmxServer();
        }
        ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc = ApplicationDescriptorUtil.getAppDescriptor(ApplicationUtil.fromConfig(config), config);
        TaskFactory taskFactory = TaskFactoryUtil.getTaskFactory(appDesc);
        Option<String> option = ShellCommandConfig$.MODULE$.Config2ShellCommand(config).getTaskOpts();
        if (option instanceof Some) {
            this.warn((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%s was specified in config, but is not being used because job is being executed with ThreadJob. You probably want to run %s=%s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ShellCommandConfig$.MODULE$.TASK_JVM_OPTS(), JobConfig$.MODULE$.STREAM_JOB_FACTORY_CLASS(), ProcessJobFactory.class.getName()}));
                }
            });
            none$ = BoxedUnit.UNIT;
        } else {
            none$ = None$.MODULE$;
        }
        ProcessorLifecycleListener processorLifecycleListener = appDesc.getProcessorLifecycleListenerFactory().createInstance(new ProcessorContext(this){}, config);
        SamzaContainerListener containerListener = new SamzaContainerListener(this, processorLifecycleListener){
            private final ProcessorLifecycleListener processorLifecycleListener$1;

            public void afterFailure(Throwable t) {
                this.processorLifecycleListener$1.afterFailure(t);
                throw t;
            }

            public void afterStart() {
                this.processorLifecycleListener$1.afterStart();
            }

            public void afterStop() {
                this.processorLifecycleListener$1.afterStop();
            }

            public void beforeStart() {
                this.processorLifecycleListener$1.beforeStart();
            }
            {
                this.processorLifecycleListener$1 = processorLifecycleListener$1;
            }
        };
        try {
            coordinator.start();
            SamzaContainer container = SamzaContainer$.MODULE$.apply(containerId, jobModel, (scala.collection.immutable.Map<String, MetricsReporter>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), taskFactory, JobContextImpl.fromConfigWithDefaults(config), (Option<ApplicationContainerContextFactory<ApplicationContainerContext>>)Option$.MODULE$.apply(appDesc.getApplicationContainerContextFactory().orElse(null)), (Option<ApplicationTaskContextFactory<ApplicationTaskContext>>)Option$.MODULE$.apply(appDesc.getApplicationTaskContextFactory().orElse(null)));
            container.setContainerListener(containerListener);
            ThreadJob threadJob = new ThreadJob(container);
            return threadJob;
        }
        finally {
            coordinator.stop();
            coordinatorStreamManager.stop();
            if (jmxServer != null) {
                jmxServer.stop();
            }
        }
    }

    public ThreadJobFactory() {
        Logging$class.$init$(this);
    }
}

